/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.SortInfo;
import org.apache.log4j.Logger;

public class UpdateOrderScanCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(UpdateOrderScanCmd.class);
    private final SortInfo sortInfo;

    public UpdateOrderScanCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "UpdateOrderScan";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "update tt_orders set scanQty=scanQty+1 where id=?";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strInsertSql);
            OrderInfo orderInfo = this.sortInfo.getOrderInfo();
            long id = orderInfo.getOrderID();
            dbOperator.setLong(1, id);
            int rs = dbOperator.executeUpdate();
            if (rs > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when UpdateOrderScanCmd ount : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

