/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.util.List;
import org.apache.log4j.Logger;

public class UpdateOffStatusCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(UpdateOffStatusCmd.class);
    private final List<Long> idList;

    public UpdateOffStatusCmd(List<Long> idList) {
        this.idList = idList;
    }

    @Override
    public String getName() {
        return "UpdateOffStatusCmd";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "update tt_packet_off set uploadStatus=1 where id=?";
        try {
            dbOperator.clearParameters();
            dbOperator.setAutoCommit(false);
            dbOperator.prepareStatement(strInsertSql);
            for (long Id : this.idList) {
                dbOperator.setLong(1, Id);
                dbOperator.addBatch();
            }
            int[] rs = dbOperator.executeBatch();
            dbOperator.commit();
            dbOperator.setAutoCommit(true);
            if (rs.length > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when UpdateOffStatusCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

