/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.LpnInfo;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class UpdateLpnWaybillCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(UpdateLpnWaybillCmd.class);
    private final LpnInfo lpnInfo;

    public UpdateLpnWaybillCmd(LpnInfo lpnInfo) {
        this.lpnInfo = lpnInfo;
    }

    @Override
    public String getName() {
        return "UpdateLpnWaybill";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strUpdateSql = "update tt_lpn_slot set wayBill=?,dwsSlot=?,deliverName=?,lpnCheckTime=?,status=1 where lpn=?";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strUpdateSql);
            String waybill = this.lpnInfo.getWayBill();
            if (waybill == null || waybill.equals("")) {
                waybill = "none";
            }
            dbOperator.setString(1, waybill);
            int dwsSlot = this.lpnInfo.getDwsSlot();
            dbOperator.setInt(2, dwsSlot);
            String deliverName = this.lpnInfo.getDeliverName();
            if (deliverName == null || deliverName.equals("")) {
                deliverName = "none";
            }
            dbOperator.setString(3, deliverName);
            Timestamp checkTime = this.lpnInfo.getOrderCheckedTime();
            if (checkTime == null) {
                checkTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            dbOperator.setTimestamp(4, checkTime);
            String lpn = this.lpnInfo.getLpn();
            if (lpn == null || lpn.equals("")) {
                lpn = "none";
            }
            dbOperator.setString(5, lpn);
            int rs = dbOperator.executeUpdate();
            if (rs > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when UpdateLpnWaybill : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

