/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;

public class UpdateLpnStatusCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(UpdateLpnStatusCmd.class);
    private final SlotInfo slotInfo;

    public UpdateLpnStatusCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return "UpdateLpnStatus";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "update  tt_lpn_slot set status=1 where lpn=? and slot=?";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strInsertSql);
            String lpn = this.slotInfo.getLpn();
            String slot = this.slotInfo.getSlotId();
            dbOperator.setString(1, lpn);
            dbOperator.setInt(2, Integer.parseInt(slot));
            int rs = dbOperator.executeUpdate();
            if (rs > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when LpnStatusUpdate : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

