/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;

public class UpdateLpnActQtyCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(UpdateLpnActQtyCmd.class);
    private final SlotInfo slotInfo;

    public UpdateLpnActQtyCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return "UpdateLpnActQty";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "update  tt_lpn_slot set actQty=actQty+1,status=? where lpn=? and slot=?";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strInsertSql);
            String lpn = this.slotInfo.getLpn();
            String slot = this.slotInfo.getSlotId();
            int status = 0;
            if (this.slotInfo.getLpnQty() == this.slotInfo.getMailCount()) {
                status = 1;
            }
            dbOperator.setInt(1, status);
            dbOperator.setString(2, lpn);
            dbOperator.setInt(3, Integer.parseInt(slot));
            int rs = dbOperator.executeUpdate();
            if (rs > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when UpdateLpnActQty : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

