/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SlotInfo;
import org.apache.log4j.Logger;

public class RemoveOrderLpnCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(RemoveOrderLpnCmd.class);
    private final SlotInfo slotInfo;

    public RemoveOrderLpnCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return "RemoveOrderLpn";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strDelteSql = "delete from tt_orders where lpn=?";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strDelteSql);
            String lpn = this.slotInfo.getLpn();
            dbOperator.setString(1, lpn);
            int rs = dbOperator.executeUpdate();
            if (rs > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when RemoveOrderLpn : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

