/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.VersionInfo;
import java.sql.ResultSet;
import java.util.concurrent.ConcurrentHashMap;

public class FetchVersionInfo
implements ICommand {
    private ConcurrentHashMap<String, VersionInfo> versionMap = new ConcurrentHashMap();
    private final String sql = "select * from tt_version_info;";

    @Override
    public String getName() {
        return "FetchVersionInfo";
    }

    public FetchVersionInfo(ConcurrentHashMap<String, VersionInfo> versionMap) {
        this.versionMap = versionMap;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                ret = true;
                VersionInfo version = new VersionInfo();
                String fileName = rs.getString("fileName");
                String vers = rs.getString("version");
                String url = rs.getString("url");
                version.setFileName(fileName);
                version.setVersion(vers);
                version.setUpdateUrl(url);
                this.versionMap.put(fileName, version);
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

