/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class FetchSlotStatusCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchSlotStatusCmd.class);
    private final SlotInfo slotInfo;

    public FetchSlotStatusCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return "FetchSlotStatus";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_slot_status  where slot=?";
        try {
            dbOperator.prepareStatement(sql);
            dbOperator.setInt(1, Integer.parseInt(this.slotInfo.getSlotId()));
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String mode = rs.getString("mode");
                this.slotInfo.setSortInfoMode(mode);
                int qty = rs.getInt("qty");
                this.slotInfo.setLpnQty(qty);
                int mailCount = rs.getInt("actQty");
                this.slotInfo.setMailCount(mailCount);
                Timestamp ts = rs.getTimestamp("firstPacketOffTime");
                if (ts == null) {
                    ts = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
                }
                this.slotInfo.setBeginTime(ts);
                int isLock = rs.getInt("isLock");
                this.slotInfo.setIsLocked(isLock);
                int isOpen = rs.getInt("isOpen");
                this.slotInfo.setIsOpen(isOpen);
                int isElectricFull = rs.getInt("isElectricFull");
                this.slotInfo.setIsShadow(isElectricFull);
                String lockMode = rs.getString("lockMode");
                if (lockMode == null || lockMode.equalsIgnoreCase("")) {
                    lockMode = "N";
                }
                this.slotInfo.setLockMode(lockMode);
            }
            ret = true;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when FetchSlotStatusCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

