/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LogUtil;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.OrderManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.LpnInfo;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class FetchSkuOrderInfoDCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchSkuOrderInfoDCmd.class);
    private final SortInfo sortInfo;
    private static final int EXPIRE_TIME = 43200000;

    public FetchSkuOrderInfoDCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "FetchSkuOrderInfoD";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dnow = new Date();
        dnow.setTime(dnow.getTime() - 43200000L);
        String strEndTime = df.format(dnow);
        Timestamp endTime = Timestamp.valueOf(strEndTime);
        String sql = "select * from tt_orders  where skuBarcode=? and skuStatus=0 and bigSize=0 and recordDate>? ORDER BY id asc";
        try {
            String skuBarcode = this.sortInfo.getBarcode();
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, skuBarcode);
            dbOperator.setTimestamp(2, endTime);
            ResultSet rs = dbOperator.executeQuery();
            LinkedList<OrderInfo> orderLists = new LinkedList<OrderInfo>();
            long selectID = 0L;
            Timestamp ts = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            String strK = "";
            String curLpnSku = "";
            while (rs.next()) {
                LpnInfo lpnInfo;
                String key;
                OrderInfo orderInfo = new OrderInfo();
                String skuID = rs.getString("skuID");
                if (skuID == null || skuID.equalsIgnoreCase("NULL") || skuID.equalsIgnoreCase("null") || skuID.equalsIgnoreCase(null)) {
                    skuID = "";
                }
                orderInfo.setSkuID(skuID);
                int skuQty = rs.getInt("skuQty");
                orderInfo.setSkuQty(skuQty);
                String lpn = rs.getString("lpn");
                if (lpn == null || lpn.equalsIgnoreCase("NULL") || lpn.equalsIgnoreCase("null") || lpn.equalsIgnoreCase(null)) {
                    lpn = "";
                }
                orderInfo.setLpn(lpn);
                curLpnSku = lpn + "-" + skuBarcode;
                int scanQty = rs.getInt("scanQty");
                if (scanQty >= skuQty) {
                    strK = "";
                    continue;
                }
                String lockMode = rs.getString("lockMode");
                if (lockMode == null) {
                    lockMode = "N";
                }
                orderInfo.setLockMode(lockMode);
                long orderID = rs.getLong("id");
                orderInfo.setOrderID(orderID);
                String waveID = rs.getString("waveID");
                if (waveID == null || waveID.equalsIgnoreCase("NULL") || waveID.equalsIgnoreCase("null") || waveID.equalsIgnoreCase(null)) {
                    waveID = "";
                }
                orderInfo.setWaveID(waveID);
                String taskID = rs.getString("taskID");
                if (taskID == null || taskID.equalsIgnoreCase("NULL") || taskID.equalsIgnoreCase("null") || taskID.equalsIgnoreCase(null)) {
                    taskID = "";
                }
                orderInfo.setTaskID(taskID);
                double dWeight = rs.getDouble("lpnWeight");
                orderInfo.setLpnWeight(dWeight);
                int lpnQty = rs.getInt("lpnQty");
                orderInfo.setLpnQty(lpnQty);
                orderInfo.setSkuBarcode(skuBarcode);
                strK = key = lpn + "-" + skuBarcode;
                if (OrderManager.getInstance().getSkuLpnScanMap().containsKey(key)) {
                    lpnInfo = OrderManager.getInstance().getSkuLpnScanMap().get(key);
                    Timestamp skuScaned = lpnInfo.getScanTime();
                    long lSkuTime = skuScaned.getTime();
                    long lCurTime = ts.getTime();
                    long second = (lCurTime - lSkuTime) / 1000L;
                    if (second > 3L) {
                        LogUtil.LogInfo(logger, second + ">3 s remove key " + key);
                        OrderManager.getInstance().getSkuLpnScanMap().remove(key);
                    } else {
                        LogUtil.LogInfo(logger, second + "<3 s continue key " + key);
                        continue;
                    }
                }
                orderLists.add(orderInfo);
                lpnInfo = new LpnInfo();
                lpnInfo.setScanTime(ts);
                OrderManager.getInstance().getSkuLpnScanMap().put(key, lpnInfo);
                break;
            }
            if (orderLists.size() > 0) {
                this.selectLpn(orderLists);
                ret = true;
            } else if (!this.getOrderInfoByMoveOn(dbOperator)) {
                LogUtil.LogInfo(logger, "getOrderInfoByMoveOn size()==0 " + curLpnSku);
                if (!this.getOrderInfoByPacketOn(dbOperator)) {
                    LogUtil.LogInfo(logger, "at last PacketOn size()==0 " + curLpnSku);
                } else {
                    ret = true;
                }
            } else {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }

    private boolean getOrderInfoByMoveOn(DbOperator dbOperator) {
        boolean ret = false;
        String sql = "select * from tt_orders  where skuBarcode=? and skuStatus=0 and bigSize=0  ORDER BY moveOnQty asc";
        try {
            dbOperator.clearParameters();
            String skuBarcode = this.sortInfo.getBarcode();
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, skuBarcode);
            ResultSet rs = dbOperator.executeQuery();
            LinkedList<OrderInfo> orderLists = new LinkedList<OrderInfo>();
            long selectID = 0L;
            Timestamp ts = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            String strK = "";
            while (rs.next()) {
                LpnInfo lpnInfo;
                String key;
                OrderInfo orderInfo = new OrderInfo();
                String skuID = rs.getString("skuID");
                if (skuID == null || skuID.equalsIgnoreCase("NULL") || skuID.equalsIgnoreCase("null") || skuID.equalsIgnoreCase(null)) {
                    skuID = "";
                }
                orderInfo.setSkuID(skuID);
                int skuQty = rs.getInt("skuQty");
                orderInfo.setSkuQty(skuQty);
                int moveOnQty = rs.getInt("moveOnQty");
                if (moveOnQty >= skuQty) {
                    strK = "";
                    continue;
                }
                long orderID = rs.getLong("id");
                orderInfo.setOrderID(orderID);
                double dWeight = rs.getDouble("lpnWeight");
                orderInfo.setLpnWeight(dWeight);
                String waveID = rs.getString("waveID");
                if (waveID == null || waveID.equalsIgnoreCase("NULL") || waveID.equalsIgnoreCase("null") || waveID.equalsIgnoreCase(null)) {
                    waveID = "";
                }
                orderInfo.setWaveID(waveID);
                String taskID = rs.getString("taskID");
                if (taskID == null || taskID.equalsIgnoreCase("NULL") || taskID.equalsIgnoreCase("null") || taskID.equalsIgnoreCase(null)) {
                    taskID = "";
                }
                orderInfo.setTaskID(taskID);
                String lpn = rs.getString("lpn");
                if (lpn == null || lpn.equalsIgnoreCase("NULL") || lpn.equalsIgnoreCase("null") || lpn.equalsIgnoreCase(null)) {
                    lpn = "";
                }
                orderInfo.setLpn(lpn);
                int lpnQty = rs.getInt("lpnQty");
                orderInfo.setLpnQty(lpnQty);
                orderInfo.setSkuBarcode(skuBarcode);
                String lockMode = rs.getString("lockMode");
                if (lockMode == null) {
                    lockMode = "N";
                }
                orderInfo.setLockMode(lockMode);
                strK = key = lpn + "-" + skuBarcode;
                if (OrderManager.getInstance().getSkuLpnMoveOnMap().containsKey(key)) {
                    lpnInfo = OrderManager.getInstance().getSkuLpnMoveOnMap().get(key);
                    Timestamp skuScaned = lpnInfo.getScanTime();
                    long lSkuTime = skuScaned.getTime();
                    long lCurTime = ts.getTime();
                    long second = (lCurTime - lSkuTime) / 1000L;
                    if (second > 8L) {
                        LogUtil.LogInfo(logger, second + ">8 s remove key " + key);
                        OrderManager.getInstance().getSkuLpnMoveOnMap().remove(key);
                    } else {
                        LogUtil.LogInfo(logger, second + "<8 s continue key " + key);
                        continue;
                    }
                }
                orderLists.add(orderInfo);
                lpnInfo = new LpnInfo();
                lpnInfo.setScanTime(ts);
                OrderManager.getInstance().getSkuLpnMoveOnMap().put(key, lpnInfo);
                break;
            }
            if (orderLists.size() > 0) {
                this.selectLpn(orderLists);
                ret = true;
            } else {
                LogUtil.LogInfo(logger, "pack on orderLists.size()==0 " + strK);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }

    private boolean getOrderInfoByPacketOn(DbOperator dbOperator) {
        boolean ret = false;
        String sql = "select * from tt_orders  where skuBarcode=? and skuStatus=0 and bigSize=0  ORDER BY packetOnSkuQty asc";
        try {
            dbOperator.clearParameters();
            String skuBarcode = this.sortInfo.getBarcode();
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, skuBarcode);
            ResultSet rs = dbOperator.executeQuery();
            LinkedList<OrderInfo> orderLists = new LinkedList<OrderInfo>();
            long selectID = 0L;
            Timestamp ts = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            String strK = "";
            while (rs.next()) {
                LpnInfo lpnInfo;
                String key;
                OrderInfo orderInfo = new OrderInfo();
                String skuID = rs.getString("skuID");
                if (skuID == null || skuID.equalsIgnoreCase("NULL") || skuID.equalsIgnoreCase("null") || skuID.equalsIgnoreCase(null)) {
                    skuID = "";
                }
                orderInfo.setSkuID(skuID);
                int skuQty = rs.getInt("skuQty");
                orderInfo.setSkuQty(skuQty);
                int packOnQty = rs.getInt("packetOnSkuQty");
                if (packOnQty >= skuQty) {
                    strK = "";
                    continue;
                }
                long orderID = rs.getLong("id");
                orderInfo.setOrderID(orderID);
                String waveID = rs.getString("waveID");
                if (waveID == null || waveID.equalsIgnoreCase("NULL") || waveID.equalsIgnoreCase("null") || waveID.equalsIgnoreCase(null)) {
                    waveID = "";
                }
                orderInfo.setWaveID(waveID);
                String taskID = rs.getString("taskID");
                if (taskID == null || taskID.equalsIgnoreCase("NULL") || taskID.equalsIgnoreCase("null") || taskID.equalsIgnoreCase(null)) {
                    taskID = "";
                }
                orderInfo.setTaskID(taskID);
                String lpn = rs.getString("lpn");
                if (lpn == null || lpn.equalsIgnoreCase("NULL") || lpn.equalsIgnoreCase("null") || lpn.equalsIgnoreCase(null)) {
                    lpn = "";
                }
                orderInfo.setLpn(lpn);
                double dWeight = rs.getDouble("lpnWeight");
                orderInfo.setLpnWeight(dWeight);
                int lpnQty = rs.getInt("lpnQty");
                orderInfo.setLpnQty(lpnQty);
                orderInfo.setSkuBarcode(skuBarcode);
                String lockMode = rs.getString("lockMode");
                if (lockMode == null) {
                    lockMode = "N";
                }
                orderInfo.setLockMode(lockMode);
                strK = key = lpn + "-" + skuBarcode;
                if (OrderManager.getInstance().getPackOnSkuLpnMap().containsKey(key)) {
                    lpnInfo = OrderManager.getInstance().getPackOnSkuLpnMap().get(key);
                    Timestamp skuScaned = lpnInfo.getScanTime();
                    long lSkuTime = skuScaned.getTime();
                    long lCurTime = ts.getTime();
                    long second = (lCurTime - lSkuTime) / 1000L;
                    if (second > 8L) {
                        LogUtil.LogInfo(logger, second + ">8 s remove key " + key);
                        OrderManager.getInstance().getPackOnSkuLpnMap().remove(key);
                    } else {
                        LogUtil.LogInfo(logger, second + "<8 s continue key " + key);
                        continue;
                    }
                }
                orderLists.add(orderInfo);
                lpnInfo = new LpnInfo();
                lpnInfo.setScanTime(ts);
                OrderManager.getInstance().getPackOnSkuLpnMap().put(key, lpnInfo);
                break;
            }
            if (orderLists.size() > 0) {
                this.selectLpn(orderLists);
                ret = true;
            } else {
                LogUtil.LogInfo(logger, "pack on orderLists.size()==0 " + strK);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }

    private void selectLpn(List<OrderInfo> orderLists) {
        try {
            if (orderLists == null) {
                return;
            }
            OrderInfo selectedOrder = orderLists.get(0);
            for (int i = 0; i < orderLists.size(); ++i) {
                OrderInfo orderInfo = orderLists.get(i);
                if (orderInfo.getPriority() <= selectedOrder.getPriority()) continue;
                selectedOrder = orderInfo;
            }
            this.sortInfo.setOrderInfo(selectedOrder);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when selectLpn : " + ex.getMessage(), 2));
        }
    }
}

