/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class FetchReturnSlotCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchReturnSlotCmd.class);
    private SortInfo sortInfo;

    public FetchReturnSlotCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "FetchModeCmd";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select slot from tt_return_plan where logicSlot=?";
        try {
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, this.sortInfo.getLocation());
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                int slot = rs.getInt("slot");
                this.sortInfo.getSlotsList().add(slot);
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when FetchReturnSlotCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

