/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.UploadReturnSkuInfo;
import java.sql.ResultSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class FetchReturnSkuInfoCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchReturnSkuInfoCmd.class);
    private UploadReturnSkuInfo uploadReturnSkuInfo;

    public FetchReturnSkuInfoCmd(UploadReturnSkuInfo uploadReturnSkuInfo) {
        this.uploadReturnSkuInfo = uploadReturnSkuInfo;
    }

    @Override
    public String getName() {
        return "FetchReturnSkuInfoCmd";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_packet_off  where droppedSlot=? and uploadStatus=0";
        try {
            dbOperator.prepareStatement(sql);
            dbOperator.setInt(1, this.uploadReturnSkuInfo.getSlotId());
            ResultSet rs = dbOperator.executeQuery();
            Map<String, UploadReturnSkuInfo> uploadReturnSkuMap = this.uploadReturnSkuInfo.getUploadReturnSkuMap();
            while (rs.next()) {
                String batchCode = rs.getString("batchCode");
                String skuBarcode = rs.getString("skuBarcode");
                Long id = rs.getLong("id");
                UploadReturnSkuInfo uploadReturnSku = new UploadReturnSkuInfo();
                String key = batchCode + "-" + skuBarcode;
                if (uploadReturnSkuMap.containsKey(key)) {
                    uploadReturnSku = uploadReturnSkuMap.get(key);
                } else {
                    uploadReturnSkuMap.put(key, uploadReturnSku);
                }
                uploadReturnSku.setBatchCode(batchCode);
                uploadReturnSku.setSkuBarcode(skuBarcode);
                int slot = rs.getInt("droppedSlot");
                uploadReturnSku.setSlotId(slot);
                String itemName = rs.getString("itemName");
                uploadReturnSku.setItemName(itemName);
                uploadReturnSku.setSkuNum(uploadReturnSku.getSkuNum() + 1);
                uploadReturnSku.setId(id);
            }
            ret = true;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when FetchReturnSkuInfoCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

