/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class FetchReturnLocationCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchReturnLocationCmd.class);
    private SortInfo sortInfo;

    public FetchReturnLocationCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "FetchReturnLocationCmd";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select logicSlot,batchCode,itemName from tt_return_package  where skuBarcode=?";
        try {
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, this.sortInfo.getBarcode());
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String location = rs.getString("logicSlot");
                this.sortInfo.setLocation(location);
                String batchCode = rs.getString("batchCode");
                this.sortInfo.setBatchCode(batchCode);
                String itemName = rs.getString("itemName");
                this.sortInfo.setItemName(itemName);
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when FetchReturnLocationCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

