/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class FetchModeCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchModeCmd.class);
    private final String platId;

    public FetchModeCmd(String platId) {
        this.platId = platId;
    }

    @Override
    public String getName() {
        return "FetchModeCmd";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select mode,platId from tt_plat_config";
        try {
            dbOperator.prepareStatement(sql);
            dbOperator.clearParameters();
            dbOperator.prepareStatement(sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String mode = rs.getString("mode");
                String dbPlatID = String.valueOf(rs.getInt("platId"));
                PlatInstance plat = null;
                plat = this.platId != null && this.platId.length() > 0 ? PlatInstanceManager.getInstance().getPlatById(this.platId) : PlatInstanceManager.getInstance().getPlatById(dbPlatID);
                if (plat.getPlatId() == null && plat.getPlatId() == "") continue;
                plat.setMode(mode);
            }
            ret = true;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when FetchModeCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

