/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.LpnInfo;
import com.simba.server.components.data.OrderInfo;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class FetchLpnInfoCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchLpnInfoCmd.class);
    private final LpnInfo lpnInfo;
    private static final int EXPIRE_TIME = 600000;

    public FetchLpnInfoCmd(LpnInfo lpnInfo) {
        this.lpnInfo = lpnInfo;
    }

    @Override
    public String getName() {
        return "FetchLpnInfo";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dnow = new Date();
        Date dBegin = new Date();
        dBegin.setTime(dBegin.getTime() - 14400000L);
        String strBegin = df.format(dBegin);
        Timestamp beginTime = Timestamp.valueOf(strBegin);
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_orders  where lpn=? and recordDate>?";
        try {
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, this.lpnInfo.getLpn());
            dbOperator.setTimestamp(2, beginTime);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                long ID2 = rs.getLong("id");
                this.lpnInfo.setId(ID2);
                String skuBarcode = rs.getString("skuBarcode");
                if (skuBarcode == null || skuBarcode.length() < 3) continue;
                int lpnQty = rs.getInt("lpnQty");
                this.lpnInfo.setLpnQty(lpnQty);
                int skuQty = rs.getInt("skuQty");
                OrderInfo order = new OrderInfo();
                order.setSkuBarcode(skuBarcode);
                order.setSkuQty(skuQty);
                order.setPackOffQty(0);
                if (this.lpnInfo.getSkuMap().containsKey(skuBarcode)) continue;
                this.lpnInfo.getSkuMap().put(skuBarcode, order);
            }
            ret = true;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when FetchLpnInfoCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

