/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.LpnInfo;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class FetchLpnExpireInfoCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchLpnExpireInfoCmd.class);
    private final List<LpnInfo> lpnInfoList;
    private static final int EXPIRE_TIME = 600000;

    public FetchLpnExpireInfoCmd(List<LpnInfo> lpnInfoList) {
        this.lpnInfoList = lpnInfoList;
    }

    @Override
    public String getName() {
        return "FetchLpnExpireInfo";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dnow = new Date();
        Date dBegin = new Date();
        dnow.setTime(dnow.getTime() - 600000L);
        dBegin.setTime(dBegin.getTime() - 14400000L);
        String strBegin = df.format(dBegin);
        String strEndTime = df.format(dnow);
        Timestamp endTime = Timestamp.valueOf(strEndTime);
        Timestamp beginTime = Timestamp.valueOf(strBegin);
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_lpn_slot  where status=0 and beginTime<? and beginTime>?";
        try {
            dbOperator.prepareStatement(sql);
            dbOperator.setTimestamp(1, endTime);
            dbOperator.setTimestamp(2, beginTime);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                LpnInfo lpnInfo = new LpnInfo();
                long ID2 = rs.getLong("id");
                lpnInfo.setId(ID2);
                int slot = rs.getInt("slot");
                lpnInfo.setSlot(slot);
                if (SlotManager.getInstance().checkSlotIsTrash(String.valueOf(slot)).booleanValue()) continue;
                int lpnQty = rs.getInt("lpnQty");
                lpnInfo.setLpnQty(lpnQty);
                int lpnAct = rs.getInt("actQty");
                lpnInfo.setActQty(lpnAct);
                if (lpnAct >= lpnQty) continue;
                this.lpnInfoList.add(lpnInfo);
            }
            ret = true;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when FetchLpnExpireInfo : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

