/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.UploadInfo;
import java.sql.ResultSet;
import java.util.List;
import org.apache.log4j.Logger;

public class FetchDwsUploadInfoCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchDwsUploadInfoCmd.class);
    private final List<UploadInfo> dwsUploadInfoList;

    public FetchDwsUploadInfoCmd(List<UploadInfo> dwsUploadInfoList) {
        this.dwsUploadInfoList = dwsUploadInfoList;
    }

    @Override
    public String getName() {
        return "FetchDwsUploadInfo";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_dws_packet_off  where uploadFlag=0 and droppedSlot<99  and uploadNum<4 ORDER BY id desc limit 100";
        try {
            dbOperator.prepareStatement(sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                UploadInfo dwsUpload = new UploadInfo();
                long ID2 = rs.getLong("id");
                dwsUpload.setId(ID2);
                String wayBill = rs.getString("barcode");
                if (wayBill == null) continue;
                dwsUpload.setWayBill(wayBill);
                int droppedSlot = rs.getInt("droppedSlot");
                dwsUpload.setWayDirection(droppedSlot);
                double lpnWeight = rs.getDouble("lpnWeight");
                dwsUpload.setOrderWeight(lpnWeight);
                double dwsWeight = rs.getDouble("packageWeight");
                dwsUpload.setActWeight(dwsWeight);
                this.dwsUploadInfoList.add(dwsUpload);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when FetchDwsUploadInfoCmd : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

