/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.LpnInfo;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class FetchDelOrderInfoDCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(FetchDelOrderInfoDCmd.class);
    private final SortInfo sortInfo;
    private static final int EXPIRE_TIME = 43200000;

    public FetchDelOrderInfoDCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "FetchDelOrderInfoD";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dnow = new Date();
        dnow.setTime(dnow.getTime() - 43200000L);
        String strEndTime = df.format(dnow);
        Timestamp endTime = Timestamp.valueOf(strEndTime);
        String sql = "select * from tt_orders  where skuBarcode=? and skuStatus=0 and bigSize=0 and recordDate>? ORDER BY id asc limit 1";
        try {
            String skuBarcode = this.sortInfo.getBarcode();
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, skuBarcode);
            dbOperator.setTimestamp(2, endTime);
            ResultSet rs = dbOperator.executeQuery();
            LinkedList<OrderInfo> orderLists = new LinkedList<OrderInfo>();
            long selectID = 0L;
            Timestamp ts = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            String strK = "";
            String curLpnSku = "";
            while (rs.next()) {
                OrderInfo orderInfo = new OrderInfo();
                String skuID = rs.getString("skuID");
                if (skuID == null || skuID.equalsIgnoreCase("NULL") || skuID.equalsIgnoreCase("null") || skuID.equalsIgnoreCase(null)) {
                    skuID = "";
                }
                orderInfo.setSkuID(skuID);
                int skuQty = rs.getInt("skuQty");
                orderInfo.setSkuQty(skuQty);
                String lpn = rs.getString("lpn");
                if (lpn == null || lpn.equalsIgnoreCase("NULL") || lpn.equalsIgnoreCase("null") || lpn.equalsIgnoreCase(null)) {
                    lpn = "";
                }
                orderInfo.setLpn(lpn);
                curLpnSku = lpn + "-" + skuBarcode;
                int scanQty = rs.getInt("scanQty");
                if (scanQty >= skuQty) {
                    strK = "";
                    continue;
                }
                String lockMode = rs.getString("lockMode");
                if (lockMode == null) {
                    lockMode = "N";
                }
                orderInfo.setLockMode(lockMode);
                long orderID = rs.getLong("id");
                orderInfo.setOrderID(orderID);
                String waveID = rs.getString("waveID");
                if (waveID == null || waveID.equalsIgnoreCase("NULL") || waveID.equalsIgnoreCase("null") || waveID.equalsIgnoreCase(null)) {
                    waveID = "";
                }
                orderInfo.setWaveID(waveID);
                String taskID = rs.getString("taskID");
                if (taskID == null || taskID.equalsIgnoreCase("NULL") || taskID.equalsIgnoreCase("null") || taskID.equalsIgnoreCase(null)) {
                    taskID = "";
                }
                orderInfo.setTaskID(taskID);
                double dWeight = rs.getDouble("lpnWeight");
                orderInfo.setLpnWeight(dWeight);
                int lpnQty = rs.getInt("lpnQty");
                orderInfo.setLpnQty(lpnQty);
                orderInfo.setSkuBarcode(skuBarcode);
                orderLists.add(orderInfo);
                LpnInfo lpnInfo = new LpnInfo();
                lpnInfo.setScanTime(ts);
                break;
            }
            if (orderLists.size() > 0) {
                this.selectLpn(orderLists);
                ret = true;
            } else {
                ret = false;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query del barcode info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }

    private void selectLpn(List<OrderInfo> orderLists) {
        try {
            if (orderLists == null) {
                return;
            }
            OrderInfo selectedOrder = orderLists.get(0);
            for (int i = 0; i < orderLists.size(); ++i) {
                OrderInfo orderInfo = orderLists.get(i);
                if (orderInfo.getPriority() <= selectedOrder.getPriority()) continue;
                selectedOrder = orderInfo;
            }
            this.sortInfo.setOrderInfo(selectedOrder);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when selectLpn : " + ex.getMessage(), 2));
        }
    }
}

