/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.DeleteData;
import org.apache.log4j.Logger;

public class DelStaleDataCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(DelStaleDataCmd.class);
    public static final String NAME = "DelPacketOffCmd";
    private final DeleteData deleteData;
    private final String sql = "delete from ? where recordTime<? limit 10000;";

    public DelStaleDataCmd(DeleteData deleteData) {
        this.deleteData = deleteData;
    }

    @Override
    public String getName() {
        return "DelStaleDataCmd";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            dbOperator.setString(1, this.deleteData.getDelName());
            dbOperator.setTimestamp(2, this.deleteData.getDeleteBeforeTime());
            int delCount = dbOperator.executeUpdate();
            if (delCount > 0) {
                this.deleteData.setDelCount(delCount);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query del staleData info : " + ex.getMessage(), 2));
        }
        return ret;
    }
}

