/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.SortInfo;
import java.sql.Timestamp;
import org.json.JSONObject;

public class AddScannedCmd
implements ICommand {
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_scanned_info(platId,waveID,taskID,lpn,lpnQty,skuBarcode,skuId,ErrorCode,weight,workerNo,sortInfoMode,recordDate) values(?,?,?,?,?,?,?,?,?,?,?,?);";

    public AddScannedCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "AddScanned";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            OrderInfo orderInfo = this.sortInfo.getOrderInfo();
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String platId = String.valueOf(this.sortInfo.getPlcPlatID());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(1, platId);
            String waveID = orderInfo.getWaveID();
            if (waveID == null || waveID.equals("")) {
                waveID = "none";
            }
            dbOperator.setString(2, waveID);
            String taskID = orderInfo.getTaskID();
            if (taskID == null || taskID.equals("")) {
                taskID = "none";
            }
            dbOperator.setString(3, taskID);
            String lpn = orderInfo.getLpn();
            if (lpn == null || lpn.equals("")) {
                lpn = "none";
            }
            dbOperator.setString(4, lpn);
            int lpnQty = orderInfo.getLpnQty();
            dbOperator.setInt(5, lpnQty);
            String skuBarcode = orderInfo.getSkuBarcode();
            if (skuBarcode == null || skuBarcode.equals("")) {
                skuBarcode = "none";
            }
            dbOperator.setString(6, skuBarcode);
            String skuID = orderInfo.getSkuID();
            if (skuID == null || skuID.equals("")) {
                skuID = "none";
            }
            dbOperator.setString(7, skuID);
            int serverErrorCode = this.sortInfo.getServerErrorCode();
            dbOperator.setInt(8, serverErrorCode);
            double weight = orderInfo.getLpnWeight();
            dbOperator.setDouble(9, weight);
            JSONObject dataObj = this.sortInfo.getDataObj();
            String workerNo = "none";
            if (dataObj.has("workerNo")) {
                workerNo = dataObj.getString("workerNo");
            }
            dbOperator.setString(10, workerNo);
            String mode = "none";
            if (dataObj.has("Mode")) {
                mode = dataObj.getString("Mode");
            }
            dbOperator.setString(11, mode);
            Timestamp scannedTime = this.sortInfo.getTimestampScanned();
            if (scannedTime == null) {
                scannedTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String scannedTimeContent = scannedTime.toString();
            dbOperator.setString(12, scannedTimeContent);
            int res = dbOperator.executeUpdate();
            ret = res <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

