/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.ReturnPackageInfo;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;

public class AddReturnInfoCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(AddReturnInfoCmd.class);
    private final List<ReturnPackageInfo> returnPackageList;

    public AddReturnInfoCmd(List<ReturnPackageInfo> returnPackageList) {
        this.returnPackageList = returnPackageList;
    }

    @Override
    public String getName() {
        return "AddReturnPackageInfo";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "insert into tt_return_package(batchCode,skuBarcode,itemName,skuNumber,logicSlot,recordDate) values (?,?,?,?,?,?)";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strInsertSql);
            dbOperator.setAutoCommit(false);
            Timestamp ts = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            for (ReturnPackageInfo returnPackageInfo : this.returnPackageList) {
                dbOperator.setString(1, returnPackageInfo.getBatchCode());
                dbOperator.setString(2, returnPackageInfo.getSkuBarcode());
                dbOperator.setString(3, returnPackageInfo.getItemName());
                dbOperator.setInt(4, returnPackageInfo.getSkuNumber());
                dbOperator.setString(5, returnPackageInfo.getLogicSlot());
                dbOperator.setTimestamp(6, ts);
                dbOperator.addBatch();
            }
            int[] rs = dbOperator.executeBatch();
            dbOperator.commit();
            dbOperator.setAutoCommit(true);
            if (rs.length > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query return info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

