/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.OrderInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.data.SlotManager;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AddPacketOffCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(AddPacketOffCmd.class);
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_packet_off(lpn,lpnQty,skuBarcode,carId,platId,plcId,slotsContent,droppedSlot,sortingId,packCode,turnNumber,mode,skuQty,recordDate,batchCode,itemName) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public AddPacketOffCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "AddPacketOff";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        String strSlots = "";
        try {
            String subSlotcontents;
            DbOperator dbOperator = (DbOperator)params;
            SlotManager.getInstance().LastPacketOffTime = new Date().getTime();
            dbOperator.prepareStatement(this.sql);
            OrderInfo orderInfo = this.sortInfo.getOrderInfo();
            String lpn = orderInfo.getLpn();
            if (lpn == null || lpn.equals("")) {
                lpn = "none";
            }
            dbOperator.setString(1, lpn);
            int lpnQty = orderInfo.getLpnQty();
            dbOperator.setInt(2, lpnQty);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(3, barcode);
            String carId = this.sortInfo.getCarId();
            if (carId == null || carId.equals("")) {
                carId = "0";
            }
            if (carId.contains("-")) {
                carId = carId.substring(carId.indexOf("-") + 1);
            }
            dbOperator.setString(4, carId);
            String platId = String.valueOf(this.sortInfo.getPlcPlatID());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(5, platId);
            String plcId = this.sortInfo.getPlcId();
            if (plcId == null || plcId.equals("")) {
                plcId = "none";
            }
            dbOperator.setString(6, plcId);
            StringBuilder slotsContent = new StringBuilder();
            int slotNum = this.sortInfo.getSlotsList().size();
            LinkedList<String> slotsListAppend = new LinkedList<String>();
            for (int i = 0; i < slotNum; ++i) {
                String strSlot = String.valueOf(this.sortInfo.getSlotsList().get(i));
                if (slotsListAppend.contains(strSlot)) continue;
                if (i != slotNum - 1) {
                    slotsContent.append(strSlot);
                    slotsContent.append(",");
                } else {
                    slotsContent.append(strSlot);
                }
                slotsListAppend.add(strSlot);
            }
            strSlots = subSlotcontents = slotsContent.toString();
            if (subSlotcontents.length() > 100) {
                subSlotcontents = subSlotcontents.substring(0, 100);
            }
            dbOperator.setString(7, subSlotcontents);
            int droppedSlot = this.sortInfo.getDroppedSlotId();
            dbOperator.setInt(8, droppedSlot);
            String sortingId = this.sortInfo.getSortingId();
            if (sortingId == null || sortingId.equals("")) {
                sortingId = "none";
            }
            if (sortingId.length() > 16) {
                sortingId = sortingId.substring(0, 16);
            }
            dbOperator.setString(9, sortingId);
            String packCode = this.sortInfo.getPackCode();
            if (packCode == null || packCode.equals("")) {
                packCode = "none";
            }
            dbOperator.setString(10, packCode);
            JSONObject dataObj = this.sortInfo.getDataObj();
            if (packCode == null || packCode.equals("")) {
                packCode = "none";
            }
            int turnNumber = this.sortInfo.getTurnNumber();
            dbOperator.setInt(11, turnNumber);
            String strMode = this.sortInfo.getPlatMode();
            dbOperator.setString(12, strMode);
            int skuQty = orderInfo.getSkuQty();
            dbOperator.setInt(13, skuQty);
            Timestamp packetOffTime = this.sortInfo.getTimestampPacketOff();
            if (packetOffTime == null) {
                packetOffTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String packetOffTimeContent = packetOffTime.toString();
            dbOperator.setString(14, packetOffTimeContent);
            String batchCode = this.sortInfo.getBatchCode();
            dbOperator.setString(15, batchCode);
            String itemName = this.sortInfo.getItemName();
            dbOperator.setString(16, itemName);
            int res = dbOperator.executeUpdate();
            ret = res <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle order Packet Off Message In PacketOffCmd Handler Error -- Exception : " + ex + " slots Content is " + strSlots, 2));
            ret = false;
        }
        return ret;
    }
}

