/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.OrderInfo;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;

public class AddOrderInfoCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(AddOrderInfoCmd.class);
    private final List<OrderInfo> listOrderBills;

    public AddOrderInfoCmd(List<OrderInfo> listOrderBills) {
        this.listOrderBills = listOrderBills;
    }

    @Override
    public String getName() {
        return "AddOrderInfo";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "insert into tt_orders(waveID,taskID,lpn,skuID,skuBarcode,skuQty,lpnQty,lpnWeight,wayDirection,recordDate,isCancelOrder,lockMode) values (?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strInsertSql);
            dbOperator.setAutoCommit(false);
            Timestamp ts = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            for (OrderInfo order : this.listOrderBills) {
                dbOperator.setString(1, order.getWaveID());
                dbOperator.setString(2, order.getTaskID());
                dbOperator.setString(3, order.getLpn());
                dbOperator.setString(4, order.getSkuID());
                dbOperator.setString(5, order.getSkuBarcode());
                dbOperator.setInt(6, order.getSkuQty());
                dbOperator.setInt(7, order.getLpnQty());
                dbOperator.setDouble(8, order.getLpnWeight());
                dbOperator.setInt(9, order.getWayDirection());
                dbOperator.setTimestamp(10, ts);
                dbOperator.setInt(11, order.getIsCancelOrder());
                dbOperator.setString(12, order.getLockMode());
                dbOperator.addBatch();
            }
            int[] rs = dbOperator.executeBatch();
            dbOperator.commit();
            dbOperator.setAutoCommit(true);
            if (rs.length > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

