/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.UploadInfo;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class AddLpnUploadStatusCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(AddLpnUploadStatusCmd.class);
    private final UploadInfo uploadInfo;

    public AddLpnUploadStatusCmd(UploadInfo uploadInfo) {
        this.uploadInfo = uploadInfo;
    }

    @Override
    public String getName() {
        return "AddLpnUploadStatus";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "insert into tt_lpn_upload(lpn,uploadStatus,content,recordDate) values (?,?,?,?)";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strInsertSql);
            Timestamp curDateTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            String lpn = this.uploadInfo.getLpn();
            int status = this.uploadInfo.getUploadStatus();
            dbOperator.setString(1, lpn);
            dbOperator.setInt(2, status);
            dbOperator.setString(3, this.uploadInfo.getContent());
            dbOperator.setTimestamp(4, curDateTime);
            int rs = dbOperator.executeUpdate();
            if (rs > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when LpnUploadStatusInsert : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

