/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.luolai;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SlotInfo;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class AddLpnStatusCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(AddLpnStatusCmd.class);
    private final SlotInfo slotInfo;

    public AddLpnStatusCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return "AddLpnStatus";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String strInsertSql = "insert into tt_lpn_slot(lpn,slot,status,beginTime,mode,lpnQty,actQty,recordDate,lpnWeight) values (?,?,?,?,?,?,?,?,?)";
        try {
            dbOperator.clearParameters();
            dbOperator.prepareStatement(strInsertSql);
            Timestamp beginLpnTime = this.slotInfo.getBeginTime();
            String lpn = this.slotInfo.getLpn();
            String slot = this.slotInfo.getSlotId();
            int status = 0;
            if (this.slotInfo.getLpnQty() == this.slotInfo.getMailCount()) {
                status = 1;
            }
            String mode = "order";
            int lpnQty = this.slotInfo.getLpnQty();
            int actQty = this.slotInfo.getMailCount();
            dbOperator.setString(1, lpn);
            dbOperator.setString(2, slot);
            dbOperator.setInt(3, status);
            dbOperator.setTimestamp(4, beginLpnTime);
            dbOperator.setString(5, mode);
            dbOperator.setInt(6, lpnQty);
            dbOperator.setInt(7, actQty);
            dbOperator.setTimestamp(8, beginLpnTime);
            dbOperator.setDouble(9, this.slotInfo.getTotalWeight());
            int rs = dbOperator.executeUpdate();
            if (rs > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when LpnStatusInsert : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

