/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ContentFilter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlTools {
    protected static final Logger logger = Logger.getLogger(XmlTools.class);
    private static final ContentFilter contentFilter = new ContentFilter(8);

    public static Document byte2Document(byte[] buf, SAXBuilder builder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        try {
            Document xmlDoc = builder.build(bais);
            bais.close();
            return xmlDoc;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static SAXBuilder createBuilder(String driver, boolean validate) {
        return new SAXBuilder(new XMLReaderSAX2Factory(validate, driver));
    }

    public static boolean document2File(Document xmlDoc, String filename) {
        try {
            Format f = Format.getPrettyFormat();
            f.setExpandEmptyElements(true);
            f.setLineSeparator(System.getProperty("line.separator"));
            XMLOutputter outputter = new XMLOutputter(f);
            FileOutputStream fos = new FileOutputStream(filename);
            outputter.output(xmlDoc, (OutputStream)fos);
            fos.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String document2String(Document xmlDoc) {
        ByteBuffer buf = XmlTools.doucment2ByteBuffer(xmlDoc, false);
        String xmlSTR = "";
        try {
            xmlSTR = new String(buf.array(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            xmlSTR = new String(buf.array());
        }
        return xmlSTR;
    }

    public static ByteBuffer doucment2ByteBuffer(Document xmlDoc, boolean isAddEnd) {
        try {
            ByteBuffer buf;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            Format f = Format.getCompactFormat();
            f.setExpandEmptyElements(true);
            f.setLineSeparator("");
            XMLOutputter outputter = new XMLOutputter(f);
            outputter.output(xmlDoc, (OutputStream)bao);
            byte[] b = bao.toByteArray();
            if (isAddEnd) {
                buf = ByteBuffer.allocate(b.length + 1);
                buf.put(b);
                buf.put((byte)0);
            } else {
                buf = ByteBuffer.allocate(b.length);
                buf.put(b);
            }
            buf.rewind();
            return buf;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ByteBuffer doucment2ByteBuffer(Document xmlDoc, byte[] shareBytes, int tailLength, boolean isAddEnd) {
        try {
            ByteBuffer buf;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            Format f = Format.getCompactFormat();
            f.setExpandEmptyElements(true);
            f.setLineSeparator("");
            XMLOutputter outputter = new XMLOutputter(f);
            outputter.output(xmlDoc.getRootElement(), (OutputStream)bao);
            byte[] b = bao.toByteArray();
            int shareBytesLength = shareBytes.length;
            int bLength = b.length;
            int offset = bLength - tailLength;
            if (isAddEnd) {
                buf = ByteBuffer.allocate(bLength + shareBytesLength + 1);
                buf.put(b, 0, offset);
                buf.put(shareBytes);
                buf.put(b, offset, tailLength);
                buf.put((byte)0);
            } else {
                buf = ByteBuffer.allocate(bLength + shareBytesLength);
                buf.put(b, 0, offset);
                buf.put(shareBytes);
                buf.put(b, offset, tailLength);
            }
            buf.rewind();
            return buf;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ByteBuffer element2ByteBuffer(Element e, boolean isAddEnd) {
        try {
            ByteBuffer buf;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            Format f = Format.getCompactFormat();
            f.setExpandEmptyElements(true);
            f.setLineSeparator("");
            XMLOutputter outputter = new XMLOutputter(f);
            outputter.output(e, (OutputStream)bao);
            byte[] b = bao.toByteArray();
            if (isAddEnd) {
                buf = ByteBuffer.allocate(b.length + 1);
                buf.put(b);
                buf.put((byte)0);
            } else {
                buf = ByteBuffer.allocate(b.length);
                buf.put(b);
            }
            buf.rewind();
            return buf;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean getInList(String liststr, String str) {
        String newstr = str.toUpperCase();
        String[] lists = liststr.split(",");
        boolean find = false;
        for (String list : lists) {
            if (!list.toUpperCase().equals(newstr)) continue;
            find = true;
            break;
        }
        return find;
    }

    public static SAXBuilder getSAXBuilder() throws IllegalAccessException {
        SAXBuilder builder = XmlTools.createBuilder("org.apache.crimson.parser.XMLReaderImpl", false);
        return builder;
    }

    public static String getTimeStr(long time) {
        SimpleDateFormat output_df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
        Date d = new Date(time);
        return output_df.format(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getXmlDocFromFile(File fp) throws Exception {
        Document xmlDoc = null;
        try {
            SAXBuilder builder = null;
            String driver = "org.apache.crimson.parser.XMLReaderImpl";
            builder = new SAXBuilder(new XMLReaderSAX2Factory(false, driver));
            xmlDoc = builder.build(fp);
        }
        catch (Exception ex) {
            if (xmlDoc == null) {
                throw ex;
            }
        }
        return xmlDoc;
    }

    public static ByteBuffer json2ByteBuffer(String json, boolean isAddEnd) {
        try {
            ByteBuffer buf;
            byte[] b = json.getBytes();
            if (isAddEnd) {
                buf = ByteBuffer.allocate(b.length + 1);
                buf.put(b);
                buf.put((byte)0);
            } else {
                buf = ByteBuffer.allocate(b.length);
                buf.put(b);
            }
            buf.rewind();
            return buf;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Element removeComment(Element element) {
        element.removeContent(contentFilter);
        List<Element> children = element.getChildren();
        for (Element e : children) {
            if (e.getChildren().size() <= 0) continue;
            XmlTools.removeComment(e);
        }
        return element;
    }

    public static Document url2Document(String urlstr) throws Exception {
        URL url = new URL(urlstr);
        return XmlTools.url2Document(url);
    }

    public static Document url2Document(URL url) throws Exception {
        Document xmlDoc = null;
        xmlDoc = XmlTools.getSAXBuilder().build(url);
        return xmlDoc;
    }
}

