/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.database;

import com.simba.GlobalParam;
import com.simba.common.database.DatabaseParamsBase;
import com.simba.common.database.DbPoolInterface;
import com.simba.common.database.MysqlPoolParams;
import com.simba.common.database.OraclePoolParams;
import com.simba.common.database.SqlserverPoolParams;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class DbPool
implements DbPoolInterface {
    private static final Logger logger = Logger.getLogger(DbPool.class);
    private final String configFileName;
    private final String dbName;
    private final DatabaseParamsBase dbParams;

    public DbPool(String configFile, String dbPoolName) {
        this.dbParams = dbPoolName.equalsIgnoreCase("oracle") ? new OraclePoolParams() : (dbPoolName.equalsIgnoreCase("sqlserver") ? new SqlserverPoolParams() : new MysqlPoolParams());
        this.dbName = dbPoolName;
        this.configFileName = "etc" + GlobalParam.PATH_SEP + configFile;
    }

    @Override
    public void closeConnection(Connection connection, PreparedStatement statement) {
        try {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), this.dbParams.getJdbcURL() + " connection error : " + ex, 2));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = DriverManager.getConnection("proxool." + this.dbParams.getAlias());
        return conn;
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection conn, String sql) {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.clearParameters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return pstmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(boolean test) {
        boolean result = false;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            this.initDbPoolParams();
            this.initPoolProperties();
            connection = this.getConnection();
            result = this.isAvailableConnection();
            this.closeConnection(connection, preparedStatement);
        }
        catch (Exception ex) {
            try {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), this.dbParams.getJdbcURL() + " connection error : " + ex, 2));
                result = false;
                this.closeConnection(connection, preparedStatement);
            }
            catch (Throwable throwable) {
                this.closeConnection(connection, preparedStatement);
                throw throwable;
            }
        }
        if (result && test) {
            try {
                connection = this.getConnection();
                String sql = this.dbParams.getHouseKeepingTestSql();
                preparedStatement = connection.prepareStatement(sql);
                ResultSet rs = preparedStatement.executeQuery();
                if (rs != null && rs.next()) {
                    String heartBeatTimes = String.valueOf(rs.getInt("heartBeat"));
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Heart beat times from database - " + this.dbName + " : " + heartBeatTimes, 3));
                }
                result = true;
                this.closeConnection(connection, preparedStatement);
            }
            catch (Exception ex) {
                try {
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "You database setting error , please check your table:" + ex, 2));
                    boolean bl = false;
                    this.closeConnection(connection, preparedStatement);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.closeConnection(connection, preparedStatement);
                    throw throwable;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailableConnection() {
        boolean result = false;
        Connection connection = null;
        try {
            connection = this.getConnection();
            result = connection != null && !connection.isClosed();
        }
        catch (Exception ex) {
            result = false;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception ex) {
                    System.out.println("Init Database Pool Error : " + ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public void shutdown() {
        try {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Shutdown dbpool " + this.dbParams.getAlias() + " now", 3));
            ProxoolFacade.removeConnectionPool(this.dbParams.getAlias());
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Shutdown dbpool " + this.dbParams.getAlias() + " error: " + ex, 3));
        }
    }

    private void initDbPoolParams() {
        this.dbParams.init(this.configFileName);
    }

    private void initPoolProperties() throws ProxoolException, ClassNotFoundException {
        Properties properties = new Properties();
        properties.put("jdbc-0.proxool.alias", this.dbParams.getAlias());
        properties.put("jdbc-0.proxool.driver-class", this.dbParams.getJdbcDriver());
        properties.put("jdbc-0.proxool.driver-url", this.dbParams.getJdbcURL());
        if (this.dbParams.getDatabaseUser().length() > 0) {
            properties.put("jdbc-0.user", this.dbParams.getDatabaseUser());
        }
        if (this.dbParams.getDatabasePassword().length() > 0) {
            properties.put("jdbc-0.password", this.dbParams.getDatabasePassword());
        }
        properties.put("jdbc-0.proxool.house-keeping-sleep-time", String.valueOf(this.dbParams.getHouseKeepingSleepTime()));
        properties.put("jdbc-0.proxool.house-keeping-test-sql", this.dbParams.getHouseKeepingTestSql());
        properties.put("jdbc-0.proxool.maximum-connection-count", String.valueOf(500));
        properties.put("jdbc-0.proxool.minimum-connection-count", String.valueOf(10));
        properties.put("jdbc-0.proxool.maximum-connection-lifetime", String.valueOf(18000000L));
        properties.put("jdbc-0.proxool.simultaneous-build-throttle", String.valueOf(30));
        properties.put("jdbc-0.proxool.recently-started-threshold", String.valueOf(40000));
        properties.put("jdbc-0.proxool.overload-without-refusal-lifetime", String.valueOf(50000L));
        properties.put("jdbc-0.proxool.maximum-active-time", String.valueOf(60000L));
        properties.put("jdbc-0.proxool.verbose", String.valueOf(false));
        properties.put("jdbc-0.proxool.trace", String.valueOf(false));
        properties.put("jdbc-0.proxool.fatal-sql-exception", "Fatal error");
        properties.put("jdbc-0.proxool.prototype-count", String.valueOf(10));
        PropertyConfigurator.configure(properties);
        Class.forName("org.logicalcobwebs.proxool.ProxoolDriver");
    }
}

