/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.command;

import com.simba.common.command.ICommand;
import com.simba.common.command.ICommandExecutor;
import com.simba.common.database.DbOperator;
import com.simba.common.database.DbPoolInterface;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import org.apache.log4j.Logger;

public class SQLCommandExecutor
implements ICommandExecutor {
    private static final Logger logger = Logger.getLogger(SQLCommandExecutor.class);
    private DbPoolInterface pool;

    public static SQLCommandExecutor getInstance() {
        return CmdExecutorHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean executeCmd(ICommand command) {
        Boolean ret = false;
        DbOperator dbOperator = new DbOperator(this.pool);
        if (command == null) {
            return ret;
        }
        try {
            ret = command.run(dbOperator);
            if (!ret.booleanValue()) {
                String name = command.getName();
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Command Executed Failed : " + name, 3));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "SQLCommandExecutor executeCmd Error: " + ex, 2));
            ret = false;
        }
        finally {
            dbOperator.close();
        }
        return ret;
    }

    public DbPoolInterface getDbPool() {
        return this.pool;
    }

    public void init() {
    }

    public void setDbPool(DbPoolInterface dbPool) {
        this.pool = dbPool;
    }

    private static class CmdExecutorHolder {
        private static SQLCommandExecutor INSTANCE = new SQLCommandExecutor();

        private CmdExecutorHolder() {
        }
    }
}

