(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["temp-temp-module"],{

/***/ "./src/app/temp/temp-routing.module.ts":
/*!*********************************************!*\
  !*** ./src/app/temp/temp-routing.module.ts ***!
  \*********************************************/
/*! exports provided: TempRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TempRoutingModule", function() { return TempRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _temp_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./temp.component */ "./src/app/temp/temp.component.ts");




var TempRoutingModule = /** @class */ (function () {
    function TempRoutingModule() {
    }
    TempRoutingModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild([
                    {
                        path: '', component: _temp_component__WEBPACK_IMPORTED_MODULE_3__["TempComponent"],
                        children: []
                    }
                ])
            ],
            exports: [
                _angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]
            ]
        })
    ], TempRoutingModule);
    return TempRoutingModule;
}());



/***/ }),

/***/ "./src/app/temp/temp.component.css":
/*!*****************************************!*\
  !*** ./src/app/temp/temp.component.css ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "table {\r\n  width: 95%;\r\n  margin-bottom: 10px;\r\n}\r\n\r\n.example-margin {\r\n  margin: 10px;\r\n}\r\n\r\ntable mat-form-field {\r\n  width: 30%;\r\n}\r\n\r\n.line {\r\n  flex: 1 1 auto;\r\n}\r\n\r\n.currentTemp{\r\n  display: flex;\r\n  align-items: center;\r\n  width: 95%;\r\n}\r\n\r\n.loading{\r\n  cursor:not-allowed;\r\n}\r\n\r\n.currentTemp span{\r\n  margin-right: 10px;\r\n  color: #9E9E9E;\r\n}\r\n\r\n.tem-content {\r\n  position: relative;\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n  justify-content: space-around\r\n}\r\n\r\n.example-loading-shade {\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  bottom: 0;\r\n  right: 0;\r\n  background: rgba(0, 0, 0, 0.15);\r\n  z-index: 99;\r\n  width: 100%;\r\n  height: 100%;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n}\r\n\r\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvdGVtcC90ZW1wLmNvbXBvbmVudC5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxXQUFXO0VBQ1gsb0JBQW9CO0NBQ3JCOztBQUVEO0VBQ0UsYUFBYTtDQUNkOztBQUVEO0VBQ0UsV0FBVztDQUNaOztBQUVEO0VBQ0UsZUFBZTtDQUNoQjs7QUFDRDtFQUNFLGNBQWM7RUFDZCxvQkFBb0I7RUFDcEIsV0FBVztDQUNaOztBQUNEO0VBQ0UsbUJBQW1CO0NBQ3BCOztBQUNEO0VBQ0UsbUJBQW1CO0VBQ25CLGVBQWU7Q0FDaEI7O0FBQ0Q7RUFDRSxtQkFBbUI7RUFDbkIsY0FBYztFQUNkLHVCQUF1QjtFQUN2QixvQkFBb0I7RUFDcEIsNkJBQTZCO0NBQzlCOztBQUVEO0VBQ0UsbUJBQW1CO0VBQ25CLE9BQU87RUFDUCxRQUFRO0VBQ1IsVUFBVTtFQUNWLFNBQVM7RUFDVCxnQ0FBZ0M7RUFDaEMsWUFBWTtFQUNaLFlBQVk7RUFDWixhQUFhO0VBQ2IsY0FBYztFQUNkLG9CQUFvQjtFQUNwQix3QkFBd0I7Q0FDekIiLCJmaWxlIjoic3JjL2FwcC90ZW1wL3RlbXAuY29tcG9uZW50LmNzcyIsInNvdXJjZXNDb250ZW50IjpbInRhYmxlIHtcclxuICB3aWR0aDogOTUlO1xyXG4gIG1hcmdpbi1ib3R0b206IDEwcHg7XHJcbn1cclxuXHJcbi5leGFtcGxlLW1hcmdpbiB7XHJcbiAgbWFyZ2luOiAxMHB4O1xyXG59XHJcblxyXG50YWJsZSBtYXQtZm9ybS1maWVsZCB7XHJcbiAgd2lkdGg6IDMwJTtcclxufVxyXG5cclxuLmxpbmUge1xyXG4gIGZsZXg6IDEgMSBhdXRvO1xyXG59XHJcbi5jdXJyZW50VGVtcHtcclxuICBkaXNwbGF5OiBmbGV4O1xyXG4gIGFsaWduLWl0ZW1zOiBjZW50ZXI7XHJcbiAgd2lkdGg6IDk1JTtcclxufVxyXG4ubG9hZGluZ3tcclxuICBjdXJzb3I6bm90LWFsbG93ZWQ7XHJcbn1cclxuLmN1cnJlbnRUZW1wIHNwYW57XHJcbiAgbWFyZ2luLXJpZ2h0OiAxMHB4O1xyXG4gIGNvbG9yOiAjOUU5RTlFO1xyXG59XHJcbi50ZW0tY29udGVudCB7XHJcbiAgcG9zaXRpb246IHJlbGF0aXZlO1xyXG4gIGRpc3BsYXk6IGZsZXg7XHJcbiAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcclxuICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gIGp1c3RpZnktY29udGVudDogc3BhY2UtYXJvdW5kXHJcbn1cclxuXHJcbi5leGFtcGxlLWxvYWRpbmctc2hhZGUge1xyXG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuICB0b3A6IDA7XHJcbiAgbGVmdDogMDtcclxuICBib3R0b206IDA7XHJcbiAgcmlnaHQ6IDA7XHJcbiAgYmFja2dyb3VuZDogcmdiYSgwLCAwLCAwLCAwLjE1KTtcclxuICB6LWluZGV4OiA5OTtcclxuICB3aWR0aDogMTAwJTtcclxuICBoZWlnaHQ6IDEwMCU7XHJcbiAgZGlzcGxheTogZmxleDtcclxuICBhbGlnbi1pdGVtczogY2VudGVyO1xyXG4gIGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG59XHJcbiJdfQ== */"

/***/ }),

/***/ "./src/app/temp/temp.component.html":
/*!******************************************!*\
  !*** ./src/app/temp/temp.component.html ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"tem-content\">\r\n  <div class=\"example-loading-shade\" *ngIf=\"!loaded\">\r\n    <mat-spinner *ngIf=\"!loaded\"></mat-spinner>\r\n  </div>\r\n  <div class=\"currentTemp\">\r\n    <span class=\"line\"></span>\r\n    <button mat-button (click)=\"getCurrentTemp()\" [ngClass]=\"{'loading':!loadTemp}\" [disabled]=\"!loadTemp\"><mat-icon>refresh</mat-icon></button>\r\n    <span>{{'temp.current_temp'|translate}}:</span>\r\n    <span *ngIf=\"currentTemp !== undefined&&loaded\" style=\"color: #000;\">{{currentTemp}}℃</span>\r\n    <span *ngIf=\"currentTemp === undefined&&loaded\" style=\"color: darkred\">{{'temp.no_temp_sensor'|translate}}</span>\r\n  </div>\r\n  <div style=\"display: flex;align-items: center;width: 95%;\">\r\n    <div>\r\n      <mat-slide-toggle\r\n        title=\"{{enable?('temp.close'|translate):('temp.open'|translate)}}\"\r\n        class=\"example-margin\"\r\n        color=\"primary\"\r\n        [(ngModel)]=\"enable\">\r\n        {{'app.temp_set'|translate}}\r\n      </mat-slide-toggle>\r\n    </div>\r\n    <mat-form-field>\r\n      <mat-select placeholder=\"Interval\" [(ngModel)]=\"interval\" [disabled]=\"!enable\">\r\n        <mat-option *ngFor=\"let inter of intervals\" [value]=\"inter\">\r\n          {{inter > 60 ? (inter / 60 + 'min') : (inter + 's')}}\r\n        </mat-option>\r\n      </mat-select>\r\n    </mat-form-field>\r\n    <span class=\"line\"></span>\r\n    <button mat-button [disabled]=\"!enable\" (click)=\"reset()\">{{'temp.reset'|translate}}</button>\r\n    <button mat-raised-button color=\"primary\" (click)=\"save()\">{{'temp.save'|translate}}</button>\r\n  </div>\r\n  <table mat-table [dataSource]=\"dataSource\" class=\"mat-elevation-z8\"\r\n         matSort (matSortChange)=\"sortData($event)\">\r\n    <ng-container matColumnDef=\"temperature\">\r\n      <th mat-header-cell *matHeaderCellDef mat-sort-header=\"temperature\">{{\"temp.temperature\"|translate}}(℃)</th>\r\n      <td mat-cell *matCellDef=\"let element\" [style.backgroundColor] = \"element.temperature===curT?'#3f51b5':'#fff'\">\r\n        {{element.temperature}}\r\n      </td>\r\n    </ng-container>\r\n\r\n    <ng-container matColumnDef=\"R\">\r\n      <th mat-header-cell *matHeaderCellDef mat-sort-header=\"R\" style=\"color: red\">{{\"temp.r\"|translate}}</th>\r\n      <td mat-cell *matCellDef=\"let element\" [style.backgroundColor] = \"element.temperature===curT?'#3f51b5':'#fff'\">\r\n        <mat-form-field class=\"example-full-width\" title=\"value:0-255\">\r\n          <input [disabled]=\"!enable\" matInput type=\"number\" [(ngModel)]=\"element.R\" min=\"0\" max=\"255\">\r\n        </mat-form-field>\r\n      </td>\r\n    </ng-container>\r\n\r\n    <ng-container matColumnDef=\"G\">\r\n      <th mat-header-cell *matHeaderCellDef mat-sort-header=\"G\" style=\"color: green\">{{\"temp.g\"|translate}}</th>\r\n      <td mat-cell *matCellDef=\"let element\" [style.backgroundColor] = \"element.temperature===curT?'#3f51b5':'#fff'\">\r\n        <mat-form-field class=\"example-full-width\" title=\"value:0-255\">\r\n          <input [disabled]=\"!enable\" matInput type=\"number\" [(ngModel)]=\"element.G\" min=\"0\" max=\"255\">\r\n        </mat-form-field>\r\n      </td>\r\n    </ng-container>\r\n\r\n    <ng-container matColumnDef=\"B\">\r\n      <th mat-header-cell *matHeaderCellDef mat-sort-header=\"B\" style=\"color: blue\">{{\"temp.b\"|translate}}</th>\r\n      <td mat-cell *matCellDef=\"let element\" [style.backgroundColor] = \"element.temperature===curT?'#3f51b5':'#fff'\">\r\n        <mat-form-field class=\"example-full-width\" title=\"value:0-255\">\r\n          <input [disabled]=\"!enable\" matInput type=\"number\" [(ngModel)]=\"element.B\" min=\"0\" max=\"255\">\r\n        </mat-form-field>\r\n      </td>\r\n    </ng-container>\r\n\r\n    <tr mat-header-row *matHeaderRowDef=\"displayedColumns\"></tr>\r\n    <tr mat-row *matRowDef=\"let row; columns: displayedColumns;\"></tr>\r\n  </table>\r\n</div>\r\n\r\n\r\n"

/***/ }),

/***/ "./src/app/temp/temp.component.ts":
/*!****************************************!*\
  !*** ./src/app/temp/temp.component.ts ***!
  \****************************************/
/*! exports provided: TempComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TempComponent", function() { return TempComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _service_http_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/http.service */ "./src/app/service/http.service.ts");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-translate/core */ "./node_modules/@ngx-translate/core/fesm5/ngx-translate-core.js");





var TempComponent = /** @class */ (function () {
    function TempComponent(httpService, translate) {
        this.httpService = httpService;
        this.translate = translate;
        this.loaded = false;
        this.loadTemp = false;
        this.conditions = [];
        this.enable = false;
        this.intervals = [10, 30, 50, 60, 180, 300, 600];
        this.displayedColumns = ['temperature', 'R', 'G', 'B'];
    }
    TempComponent.prototype.ngOnInit = function () {
        this.getCurrentTemp();
        this.getTemp();
    };
    TempComponent.prototype.getTemp = function () {
        var _this = this;
        this.loaded = false;
        var url = 'api/temperaturergb.json';
        this.httpService.getData(url).subscribe(function (data) {
            _this.loaded = true;
            _this.conditions = JSON.parse(data).conditions;
            _this.interval = JSON.parse(data).interval;
            _this.enable = JSON.parse(data).enable === 0 ? false : true;
            _this.dataSource = new _angular_material__WEBPACK_IMPORTED_MODULE_3__["MatTableDataSource"](_this.conditions);
            _this.sortedData = _this.conditions.slice();
        }, function (error) {
            console.log(error);
        });
    };
    TempComponent.prototype.getCurrentTemp = function () {
        var _this = this;
        this.loadTemp = false;
        var url = 'api/csensor.json';
        this.httpService.getData(url).subscribe(function (data) {
            _this.loadTemp = true;
            _this.currentTemp = JSON.parse(data).temperature;
            if (_this.currentTemp >= 0) {
                _this.curT = Math.round(_this.currentTemp / 10) * 10;
            }
            else {
                _this.curT = -Math.round((-_this.currentTemp) / 10) * 10;
            }
        }, function (error) {
            console.log(error);
        });
    };
    TempComponent.prototype.sortData = function (sort) {
        var data = this.conditions.slice();
        if (!sort.active || sort.direction === '') {
            this.sortedData = data;
            return;
        }
        this.sortedData = data.sort(function (a, b) {
            var isAsc = sort.direction === 'asc';
            switch (sort.active) {
                case 'temperature':
                    return compare(a.temperature, b.temperature, isAsc);
                case 'R':
                    return compare(a.R, b.R, isAsc);
                case 'G':
                    return compare(a.G, b.G, isAsc);
                case 'B':
                    return compare(a.B, b.B, isAsc);
                default:
                    return 0;
            }
        });
        this.dataSource = new _angular_material__WEBPACK_IMPORTED_MODULE_3__["MatTableDataSource"](this.sortedData);
    };
    TempComponent.prototype.reset = function () {
        this.conditions.forEach(function (ele) {
            ele.R = 255;
            ele.G = 255;
            ele.B = 255;
        });
    };
    TempComponent.prototype.save = function () {
        var _this = this;
        var error = false;
        this.conditions.forEach(function (ele) {
            if ((typeof ele.G) !== 'number' || (typeof ele.R) !== 'number' || (typeof ele.B) !== 'number' || ele.G > 255
                || ele.G < 0 || ele.R > 255 || ele.R < 0 || ele.B > 255 || ele.B < 0) {
                error = true;
            }
        });
        if (!error) {
            var body = {};
            var url = 'api/temperaturergb';
            this.loaded = false;
            if (this.enable) {
                body = {
                    'conditions': this.conditions,
                    'enable': 1,
                    'interval': this.interval
                };
            }
            else {
                body = {
                    'enable': 0
                };
            }
            this.httpService.putData(url, body).subscribe(function (data) {
                _this.getTemp();
            }, function (error1) {
                console.log(error1);
            });
        }
        else {
            this.translate.get('temp.type_error_or_out_of_limit_,_Retry').subscribe(function (res) {
                alert(res);
            });
        }
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])(_angular_material__WEBPACK_IMPORTED_MODULE_3__["MatSort"]),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_material__WEBPACK_IMPORTED_MODULE_3__["MatSort"])
    ], TempComponent.prototype, "sort", void 0);
    TempComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-temp',
            template: __webpack_require__(/*! ./temp.component.html */ "./src/app/temp/temp.component.html"),
            styles: [__webpack_require__(/*! ./temp.component.css */ "./src/app/temp/temp.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_service_http_service__WEBPACK_IMPORTED_MODULE_2__["HttpService"],
            _ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__["TranslateService"]])
    ], TempComponent);
    return TempComponent;
}());

function compare(a, b, isAsc) {
    return (a < b ? -1 : 1) * (isAsc ? 1 : -1);
}


/***/ }),

/***/ "./src/app/temp/temp.module.ts":
/*!*************************************!*\
  !*** ./src/app/temp/temp.module.ts ***!
  \*************************************/
/*! exports provided: createTranslateLoader, TempModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createTranslateLoader", function() { return createTranslateLoader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TempModule", function() { return TempModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ngx-translate/core */ "./node_modules/@ngx-translate/core/fesm5/ngx-translate-core.js");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common/http */ "./node_modules/@angular/common/fesm5/http.js");
/* harmony import */ var _ngx_translate_http_loader__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ngx-translate/http-loader */ "./node_modules/@ngx-translate/http-loader/fesm5/ngx-translate-http-loader.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _temp_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./temp.component */ "./src/app/temp/temp.component.ts");
/* harmony import */ var _temp_routing_module__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./temp-routing.module */ "./src/app/temp/temp-routing.module.ts");










function createTranslateLoader(http) {
    return new _ngx_translate_http_loader__WEBPACK_IMPORTED_MODULE_6__["TranslateHttpLoader"](http, './assets/i18n/', '.json');
}
var TempModule = /** @class */ (function () {
    function TempModule() {
    }
    TempModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            declarations: [
                _temp_component__WEBPACK_IMPORTED_MODULE_8__["TempComponent"],
            ],
            imports: [
                _temp_routing_module__WEBPACK_IMPORTED_MODULE_9__["TempRoutingModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatIconModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatExpansionModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatButtonModule"],
                _angular_common__WEBPACK_IMPORTED_MODULE_3__["CommonModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatTableModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatInputModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatSelectModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatSlideToggleModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatProgressBarModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatProgressSpinnerModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_2__["MatSortModule"],
                _ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__["TranslateModule"].forChild({
                    loader: {
                        provide: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_4__["TranslateLoader"],
                        useFactory: createTranslateLoader,
                        deps: [_angular_common_http__WEBPACK_IMPORTED_MODULE_5__["HttpClient"]]
                    }
                })
            ]
        })
    ], TempModule);
    return TempModule;
}());



/***/ })

}]);
//# sourceMappingURL=temp-temp-module.js.map