(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["display-display-module"],{

/***/ "./src/app/display/display-routing.module.ts":
/*!***************************************************!*\
  !*** ./src/app/display/display-routing.module.ts ***!
  \***************************************************/
/*! exports provided: DisplayRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DisplayRoutingModule", function() { return DisplayRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _display_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./display.component */ "./src/app/display/display.component.ts");




var DisplayRoutingModule = /** @class */ (function () {
    function DisplayRoutingModule() {
    }
    DisplayRoutingModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild([
                    {
                        path: '', component: _display_component__WEBPACK_IMPORTED_MODULE_3__["DisplayComponent"],
                        children: []
                    }
                ])
            ],
            exports: [
                _angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]
            ]
        })
    ], DisplayRoutingModule);
    return DisplayRoutingModule;
}());



/***/ }),

/***/ "./src/app/display/display.component.css":
/*!***********************************************!*\
  !*** ./src/app/display/display.component.css ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "mat-slider{\r\n  width: 300px;\r\n}\r\n\r\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvZGlzcGxheS9kaXNwbGF5LmNvbXBvbmVudC5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxhQUFhO0NBQ2QiLCJmaWxlIjoic3JjL2FwcC9kaXNwbGF5L2Rpc3BsYXkuY29tcG9uZW50LmNzcyIsInNvdXJjZXNDb250ZW50IjpbIm1hdC1zbGlkZXJ7XHJcbiAgd2lkdGg6IDMwMHB4O1xyXG59XHJcbiJdfQ== */"

/***/ }),

/***/ "./src/app/display/display.component.html":
/*!************************************************!*\
  !*** ./src/app/display/display.component.html ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<mat-list>\r\n  <mat-list-item >\r\n    <button mat-button (click)=\"setDisplay()\" style=\"cursor: pointer;\"><mat-icon>edit</mat-icon></button>\r\n  </mat-list-item>\r\n  <mat-progress-bar mode=\"indeterminate\" *ngIf=\"!loaded\"></mat-progress-bar>\r\n  <mat-list-item><div style=\"margin-right: 10px;color: #9E9E9E;\">{{'display.width'|translate}}</div>{{displayInfo['width']}}&nbsp;px</mat-list-item>\r\n  <mat-list-item><div style=\"margin-right: 10px;color: #9E9E9E;\">{{'display.height'|translate}}</div>{{displayInfo['height']}}&nbsp;px</mat-list-item>\r\n  <mat-list-item>\r\n    <div style=\"margin-right: 10px;color: #9E9E9E;\"><mat-icon>brightness_low</mat-icon></div>{{brightness}}\r\n    <mat-slider\r\n      color=\"primary\"\r\n      [(value)]=\"brightness\"\r\n      (change)=\"configBrightness($event)\"\r\n      thumbLabel\r\n      min=\"1\"\r\n      max=\"100\"></mat-slider>\r\n    <div style=\"margin-right: 10px;color: #9E9E9E;\"><mat-icon>brightness_high</mat-icon></div>\r\n    <button mat-button (click)=\"saveBrigthness()\">{{'display.save'|translate}}</button>\r\n  </mat-list-item>\r\n</mat-list>\r\n"

/***/ }),

/***/ "./src/app/display/display.component.ts":
/*!**********************************************!*\
  !*** ./src/app/display/display.component.ts ***!
  \**********************************************/
/*! exports provided: DisplayComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DisplayComponent", function() { return DisplayComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _service_http_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/http.service */ "./src/app/service/http.service.ts");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _dialogs_set_display_set_display_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dialogs/set-display/set-display.component */ "./src/app/dialogs/set-display/set-display.component.ts");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/core */ "./node_modules/@ngx-translate/core/fesm5/ngx-translate-core.js");






var DisplayComponent = /** @class */ (function () {
    function DisplayComponent(httpService, dialog, snackBar, translate) {
        this.httpService = httpService;
        this.dialog = dialog;
        this.snackBar = snackBar;
        this.translate = translate;
        this.displayInfo = {};
        this.conditions = [];
        this.tips = 'Rebooting......';
        this.rebootInterval = null;
        this.loaded = false;
        this.time = 40;
    }
    DisplayComponent.prototype.ngOnInit = function () {
        this.getDisplayInfo();
        this.getBrightness();
    };
    DisplayComponent.prototype.getBrightness = function () {
        var _this = this;
        var url = 'api/brightnessandcolortemp.json';
        this.httpService.getData(url).subscribe(function (data) {
            _this.brightness = parseInt(JSON.parse(data).brightness * 100 / 255 + '', 10);
            _this.temp = JSON.parse(data).colortemp;
        }, function (error) {
            console.log(error);
        });
    };
    DisplayComponent.prototype.configBrightness = function (e) {
        var _this = this;
        var url = 'api/brightness';
        var body = {
            'auto': 0,
            'maxAdjustValue': 100,
            'maxOriginalValue': 0,
            'maxPercent': 85,
            'method': 0,
            'minAdjustValue': 0,
            'minOriginalValue': 0,
            'minPercent': 15,
            'noneReverseGammaValues': [
                9830,
                10010,
                10190,
                10370,
                10550,
                10729,
                10909,
                11089,
                11269,
                11449,
                11629,
                11809,
                11989,
                12169,
                12349,
                12528,
                12708,
                12888,
                13068,
                13248,
                13428,
                13608,
                13788,
                13968,
                14148,
                14327,
                14507,
                14687,
                14867,
                15047,
                15227,
                15407,
                15587,
                15767,
                15947,
                16126,
                16306,
                16486,
                16666,
                16846,
                17026,
                17206,
                17386,
                17566,
                17746,
                17925,
                18105,
                18285,
                18465,
                18645,
                18825,
                19005,
                19185,
                19365,
                19544,
                19724,
                19904,
                20084,
                20264,
                20444,
                20624,
                20804,
                20984,
                21164,
                21343,
                21523,
                21703,
                21883,
                22063,
                22243,
                22423,
                22603,
                22783,
                22963,
                23142,
                23322,
                23502,
                23682,
                23862,
                24042,
                24222,
                24402,
                24582,
                24762,
                24941,
                25121,
                25301,
                25481,
                25661,
                25841,
                26021,
                26201,
                26381,
                26561,
                26740,
                26920,
                27100,
                27280,
                27460,
                27640,
                27820,
                28000,
                28180,
                28359,
                28539,
                28719,
                28899,
                29079,
                29259,
                29439,
                29619,
                29799,
                29979,
                30158,
                30338,
                30518,
                30698,
                30878,
                31058,
                31238,
                31418,
                31598,
                31778,
                31957,
                32137,
                32317,
                32497,
                32677,
                32857,
                33037,
                33217,
                33397,
                33577,
                33756,
                33936,
                34116,
                34296,
                34476,
                34656,
                34836,
                35016,
                35196,
                35376,
                35555,
                35735,
                35915,
                36095,
                36275,
                36455,
                36635,
                36815,
                36995,
                37175,
                37354,
                37534,
                37714,
                37894,
                38074,
                38254,
                38434,
                38614,
                38794,
                38973,
                39153,
                39333,
                39513,
                39693,
                39873,
                40053,
                40233,
                40413,
                40593,
                40772,
                40952,
                41132,
                41312,
                41492,
                41672,
                41852,
                42032,
                42212,
                42392,
                42571,
                42751,
                42931,
                43111,
                43291,
                43471,
                43651,
                43831,
                44011,
                44191,
                44370,
                44550,
                44730,
                44910,
                45090,
                45270,
                45450,
                45630,
                45810,
                45990,
                46169,
                46349,
                46529,
                46709,
                46889,
                47069,
                47249,
                47429,
                47609,
                47788,
                47968,
                48148,
                48328,
                48508,
                48688,
                48868,
                49048,
                49228,
                49408,
                49587,
                49767,
                49947,
                50127,
                50307,
                50487,
                50667,
                50847,
                51027,
                51207,
                51386,
                51566,
                51746,
                51926,
                52106,
                52286,
                52466,
                52646,
                52826,
                53006,
                53185,
                53365,
                53545,
                53725,
                53905,
                54085,
                54265,
                54445,
                54625,
                54805,
                54984,
                55164,
                55344,
                55524,
                55704
            ],
            'reverseGammaValues': [
                30684,
                30907,
                31128,
                31347,
                31563,
                31777,
                31989,
                32199,
                32407,
                32613,
                32817,
                33019,
                33220,
                33418,
                33615,
                33809,
                34003,
                34195,
                34385,
                34574,
                34761,
                34946,
                35131,
                35313,
                35495,
                35674,
                35852,
                36029,
                36205,
                36380,
                36554,
                36726,
                36897,
                37067,
                37235,
                37402,
                37568,
                37734,
                37898,
                38061,
                38223,
                38385,
                38545,
                38704,
                38862,
                39018,
                39174,
                39330,
                39484,
                39638,
                39790,
                39942,
                40093,
                40243,
                40391,
                40540,
                40687,
                40834,
                40980,
                41125,
                41270,
                41414,
                41557,
                41699,
                41839,
                41980,
                42120,
                42260,
                42398,
                42536,
                42674,
                42811,
                42947,
                43082,
                43216,
                43350,
                43484,
                43617,
                43749,
                43881,
                44012,
                44142,
                44272,
                44402,
                44530,
                44658,
                44786,
                44913,
                45039,
                45166,
                45291,
                45416,
                45541,
                45665,
                45788,
                45911,
                46033,
                46155,
                46277,
                46398,
                46519,
                46639,
                46758,
                46877,
                46996,
                47114,
                47232,
                47350,
                47467,
                47583,
                47699,
                47815,
                47930,
                48045,
                48159,
                48273,
                48387,
                48500,
                48613,
                48726,
                48838,
                48949,
                49061,
                49171,
                49282,
                49392,
                49502,
                49611,
                49720,
                49829,
                49938,
                50046,
                50153,
                50260,
                50367,
                50474,
                50580,
                50686,
                50792,
                50897,
                51002,
                51107,
                51211,
                51315,
                51419,
                51522,
                51625,
                51728,
                51831,
                51933,
                52035,
                52136,
                52238,
                52338,
                52439,
                52539,
                52640,
                52739,
                52839,
                52938,
                53037,
                53136,
                53234,
                53332,
                53430,
                53528,
                53625,
                53722,
                53819,
                53916,
                54012,
                54108,
                54204,
                54299,
                54395,
                54490,
                54585,
                54679,
                54773,
                54868,
                54961,
                55055,
                55148,
                55241,
                55334,
                55427,
                55519,
                55611,
                55703,
                55795,
                55887,
                55978,
                56069,
                56159,
                56250,
                56341,
                56431,
                56521,
                56611,
                56700,
                56790,
                56879,
                56967,
                57056,
                57144,
                57233,
                57321,
                57409,
                57496,
                57584,
                57671,
                57758,
                57845,
                57932,
                58018,
                58104,
                58191,
                58277,
                58362,
                58448,
                58533,
                58618,
                58703,
                58788,
                58873,
                58957,
                59041,
                59125,
                59209,
                59293,
                59377,
                59460,
                59543,
                59626,
                59709,
                59791,
                59874,
                59956,
                60039,
                60121,
                60202,
                60284,
                60365,
                60447,
                60528,
                60609,
                60690,
                60770,
                60851,
                60931,
                61012,
                61091,
                61171,
                61251,
                61330,
                61410
            ],
            'save': 0,
            'sensitivity': 0
        };
        this.httpService.postData('api/brightcurve', body).subscribe(function (data) {
            _this.httpService.putData(url, { 'brightness': parseInt((_this.brightness * 255 / 100) + '', 10) }).subscribe(function (data1) {
                _this.getBrightness();
            }, function (error) {
                console.log(error);
            });
        });
    };
    DisplayComponent.prototype.saveBrigthness = function () {
        var _this = this;
        var url = 'api/savebrightnessandcolortemp';
        var body = {
            'brightness': parseInt((this.brightness * 255 / 100) + '', 10),
            'colortemp': this.temp
        };
        this.httpService.putData(url, body).subscribe(function (data1) {
            _this.getBrightness();
        }, function (error) {
            console.log(error);
        });
    };
    DisplayComponent.prototype.getDisplayInfo = function () {
        var _this = this;
        var url = 'api/dimension.json';
        this.httpService.getData(url).subscribe(function (data) {
            _this.loaded = true;
            _this.displayInfo = JSON.parse(data);
        }, function (error) {
            console.log(error);
        });
    };
    DisplayComponent.prototype.setDisplay = function () {
        var _this = this;
        var dialogRef = this.dialog.open(_dialogs_set_display_set_display_component__WEBPACK_IMPORTED_MODULE_4__["SetDisplayComponent"], {
            width: '250px',
            data: { width: this.displayInfo['width'], height: this.displayInfo['height'] }
        });
        dialogRef.afterClosed().subscribe(function (result) {
            if (result) {
                _this.translate.get('operate.reboot...').subscribe(function (res) {
                    _this.tips = res;
                });
                result['hsync'] = 0;
                result['dclk'] = 0;
                _this.putDisplay(result);
            }
        });
    };
    DisplayComponent.prototype.putDisplay = function (body) {
        var _this = this;
        var url = 'api/dimension';
        this.httpService.putData(url, body).subscribe(function (data) {
            setInterval(function () {
                _this.snackBarRef = _this.snackBar.open(_this.tips + _this.time + 's');
                _this.time--;
            }, 1000);
            _this.rebootInterval = setTimeout(function () {
                window.location.reload();
            }, 40000);
        }, function (error) {
            console.log(error);
        });
    };
    DisplayComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-display',
            template: __webpack_require__(/*! ./display.component.html */ "./src/app/display/display.component.html"),
            styles: [__webpack_require__(/*! ./display.component.css */ "./src/app/display/display.component.css")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_service_http_service__WEBPACK_IMPORTED_MODULE_2__["HttpService"],
            _angular_material__WEBPACK_IMPORTED_MODULE_3__["MatDialog"],
            _angular_material__WEBPACK_IMPORTED_MODULE_3__["MatSnackBar"],
            _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__["TranslateService"]])
    ], DisplayComponent);
    return DisplayComponent;
}());



/***/ }),

/***/ "./src/app/display/display.module.ts":
/*!*******************************************!*\
  !*** ./src/app/display/display.module.ts ***!
  \*******************************************/
/*! exports provided: createTranslateLoader, DisplayModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createTranslateLoader", function() { return createTranslateLoader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DisplayModule", function() { return DisplayModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _display_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./display.component */ "./src/app/display/display.component.ts");
/* harmony import */ var _display_routing_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./display-routing.module */ "./src/app/display/display-routing.module.ts");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common/http */ "./node_modules/@angular/common/fesm5/http.js");
/* harmony import */ var _ngx_translate_http_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/http-loader */ "./node_modules/@ngx-translate/http-loader/fesm5/ngx-translate-http-loader.js");
/* harmony import */ var _angular_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material */ "./node_modules/@angular/material/esm5/material.es5.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ "./node_modules/@ngx-translate/core/fesm5/ngx-translate-core.js");









function createTranslateLoader(http) {
    return new _ngx_translate_http_loader__WEBPACK_IMPORTED_MODULE_5__["TranslateHttpLoader"](http, './assets/i18n/', '.json');
}
var DisplayModule = /** @class */ (function () {
    function DisplayModule() {
    }
    DisplayModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            declarations: [
                _display_component__WEBPACK_IMPORTED_MODULE_2__["DisplayComponent"]
            ],
            imports: [
                _display_routing_module__WEBPACK_IMPORTED_MODULE_3__["DisplayRoutingModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_6__["MatIconModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_6__["MatButtonModule"],
                _angular_common__WEBPACK_IMPORTED_MODULE_7__["CommonModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_6__["MatSliderModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_6__["MatListModule"],
                _angular_material__WEBPACK_IMPORTED_MODULE_6__["MatProgressBarModule"],
                _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__["TranslateModule"].forChild({
                    loader: {
                        provide: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__["TranslateLoader"],
                        useFactory: createTranslateLoader,
                        deps: [_angular_common_http__WEBPACK_IMPORTED_MODULE_4__["HttpClient"]]
                    }
                })
            ]
        })
    ], DisplayModule);
    return DisplayModule;
}());



/***/ })

}]);
//# sourceMappingURL=display-display-module.js.map