package org.jeecg.modules.wms.vo;

import java.util.List;
import org.jeecg.modules.wms.entity.WmsSo;
import org.jeecg.modules.wms.entity.WmsSoItem;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelEntity;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 出库单
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@Data
@ApiModel(value="wms_soPage对象", description="出库单")
public class WmsSoPage {

	/**主键*/
	@ApiModelProperty(value = "主键")
    private Integer id;
	/**仓库*/
	@Excel(name = "仓库", width = 15)
	@ApiModelProperty(value = "仓库")
    private String wareCode;
	/**货主编码*/
	@Excel(name = "货主编码", width = 15)
	@ApiModelProperty(value = "货主编码")
    private String ownerCode;
	/**订单号*/
	@Excel(name = "订单号", width = 15)
	@ApiModelProperty(value = "订单号")
    private String orderNo;
	/**客户订单号*/
	@Excel(name = "客户订单号", width = 15)
	@ApiModelProperty(value = "客户订单号")
    private String customerOrderNo;
	/**状态*/
	@Excel(name = "状态", width = 15)
	@ApiModelProperty(value = "状态")
    private String orderStatus;
	/**类型*/
	@Excel(name = "类型", width = 15)
	@ApiModelProperty(value = "类型")
    private String type;
	/**批次号*/
	@Excel(name = "批次号", width = 15)
	@ApiModelProperty(value = "批次号")
    private String batchNo;
	/**工作站编号*/
	@Excel(name = "工作站编号", width = 15)
	@ApiModelProperty(value = "工作站编号")
    private String stationCode;
	/**波次*/
	@Excel(name = "波次", width = 15)
	@ApiModelProperty(value = "波次")
    private String wave;
	/**优先级*/
	@Excel(name = "优先级", width = 15)
	@ApiModelProperty(value = "优先级")
    private Integer priority;
	/**执行时间*/
	@Excel(name = "执行时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "执行时间")
    private Date executeTime;
	/**完成时间*/
	@Excel(name = "完成时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "完成时间")
    private Date finishTime;
	/**创建账号*/
	@ApiModelProperty(value = "创建账号")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改账号*/
	@ApiModelProperty(value = "修改账号")
    private String updateBy;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "修改时间")
    private Date updateTime;
	
	@ExcelCollection(name="出库单子项")
	@ApiModelProperty(value = "出库单子项")
	private List<WmsSoItem> wmsSoItemList;
	
}
