package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.wms.entity.XhOutOrder;
import org.jeecg.modules.wms.entity.XhOutOrderItem;
import org.jeecg.modules.wms.mapper.XhOutOrderItemMapper;
import org.jeecg.modules.wms.mapper.XhOutOrderMapper;
import org.jeecg.modules.wms.service.IXhOutOrderService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 鑫泓出库单
 * @Author: jeecg-boot
 * @Date:   2024-11-10
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class XhOutOrderServiceImpl extends ServiceImpl<XhOutOrderMapper, XhOutOrder> implements IXhOutOrderService {

	@Autowired
	private XhOutOrderMapper xhOutOrderMapper;
	@Autowired
	private XhOutOrderItemMapper xhOutOrderItemMapper;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String id) {
		xhOutOrderItemMapper.deleteByMainId(id);
		xhOutOrderMapper.deleteById(id);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			xhOutOrderItemMapper.deleteByMainId(id.toString());
			xhOutOrderMapper.deleteById(id);
		}
	}
	
}
