package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.wms.entity.XhOutOrderRequirement;
import org.jeecg.modules.wms.entity.XhOutOrderRequirementItem;
import org.jeecg.modules.wms.mapper.XhOutOrderRequirementItemMapper;
import org.jeecg.modules.wms.mapper.XhOutOrderRequirementMapper;
import org.jeecg.modules.wms.service.IXhOutOrderRequirementService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 鑫泓出库需求单
 * @Author: jeecg-boot
 * @Date:   2024-11-10
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class XhOutOrderRequirementServiceImpl extends ServiceImpl<XhOutOrderRequirementMapper, XhOutOrderRequirement> implements IXhOutOrderRequirementService {

	@Autowired
	private XhOutOrderRequirementMapper xhOutOrderRequirementMapper;
	@Autowired
	private XhOutOrderRequirementItemMapper xhOutOrderRequirementItemMapper;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String id) {
		xhOutOrderRequirementItemMapper.deleteByMainId(id);
		xhOutOrderRequirementMapper.deleteById(id);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			xhOutOrderRequirementItemMapper.deleteByMainId(id.toString());
			xhOutOrderRequirementMapper.deleteById(id);
		}
	}
	
}
