package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.wms.entity.XhOutOrderDelivery;
import org.jeecg.modules.wms.entity.XhOutOrderDeliveryItem;
import org.jeecg.modules.wms.mapper.XhOutOrderDeliveryItemMapper;
import org.jeecg.modules.wms.mapper.XhOutOrderDeliveryMapper;
import org.jeecg.modules.wms.service.IXhOutOrderDeliveryService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 鑫宏配送单
 * @Author: jeecg-boot
 * @Date:   2024-11-29
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class XhOutOrderDeliveryServiceImpl extends ServiceImpl<XhOutOrderDeliveryMapper, XhOutOrderDelivery> implements IXhOutOrderDeliveryService {

	@Autowired
	private XhOutOrderDeliveryMapper xhOutOrderDeliveryMapper;
	@Autowired
	private XhOutOrderDeliveryItemMapper xhOutOrderDeliveryItemMapper;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String id) {
		xhOutOrderDeliveryItemMapper.deleteByMainId(id);
		xhOutOrderDeliveryMapper.deleteById(id);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			xhOutOrderDeliveryItemMapper.deleteByMainId(id.toString());
			xhOutOrderDeliveryMapper.deleteById(id);
		}
	}
	
}
