package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.wms.entity.WmsTask;
import org.jeecg.modules.wms.entity.WmsTaskItem;
import org.jeecg.modules.wms.mapper.WmsTaskItemMapper;
import org.jeecg.modules.wms.mapper.WmsTaskMapper;
import org.jeecg.modules.wms.service.IWmsTaskItemService;
import org.jeecg.modules.wms.service.IWmsTaskService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 任务
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsTaskServiceImpl extends ServiceImpl<WmsTaskMapper, WmsTask> implements IWmsTaskService {
	@Autowired
	private IWmsTaskItemService wmsTaskItemService;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String id) {
		wmsTaskItemService.deleteByMainId(id);
		this.removeById(id);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			wmsTaskItemService.deleteByMainId(id.toString());
			this.removeById(id);
		}
	}
	
}
