package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.jeecg.modules.wms.entity.WmsTaskItem;
import org.jeecg.modules.wms.mapper.WmsTaskItemMapper;
import org.jeecg.modules.wms.service.IWmsTaskItemService;
import org.springframework.stereotype.Service;
import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: 任务子项
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsTaskItemServiceImpl extends ServiceImpl<WmsTaskItemMapper, WmsTaskItem> implements IWmsTaskItemService {
	@Override
	public List<WmsTaskItem> selectByMainId(String mainId) {
		return this.list(Wrappers.<WmsTaskItem>lambdaQuery().eq(WmsTaskItem::getTaskId, mainId));
	}

	@Override
	public boolean deleteByMainId(String mainId) {
		return this.remove(Wrappers.<WmsTaskItem>lambdaQuery().eq(WmsTaskItem::getTaskId, mainId));
	}
}
