package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.jeecg.modules.wms.entity.WmsStation;
import org.jeecg.modules.wms.mapper.WmsStationMapper;
import org.jeecg.modules.wms.service.IWmsStationService;
import org.springframework.stereotype.Service;
import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: 工作站管理
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsStationServiceImpl extends ServiceImpl<WmsStationMapper, WmsStation> implements IWmsStationService {
	@Override
	public List<WmsStation> selectByMainCode(String mainCode) {
		return this.list(Wrappers.<WmsStation>lambdaQuery().eq(WmsStation::getLocCode, mainCode));
	}

	@Override
	public boolean deleteByMainCode(String mainCode) {
		return this.remove(Wrappers.<WmsStation>lambdaQuery().eq(WmsStation::getLocCode, mainCode));
	}
}
