package org.jeecg.modules.wms.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.wms.entity.WmsSo;
import org.jeecg.modules.wms.entity.WmsSoItem;
import org.jeecg.modules.wms.mapper.WmsSoItemMapper;
import org.jeecg.modules.wms.mapper.WmsSoMapper;
import org.jeecg.modules.wms.service.IWmsSoItemService;
import org.jeecg.modules.wms.service.IWmsSoService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 出库单
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsSoServiceImpl extends ServiceImpl<WmsSoMapper, WmsSo> implements IWmsSoService {
	@Autowired
	private IWmsSoItemService wmsSoItemService;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void saveMain(WmsSo wmsSo, List<WmsSoItem> wmsSoItemList) {
		this.save(wmsSo);
		if(CollectionUtil.isNotEmpty(wmsSoItemList)) {
			for(WmsSoItem entity:wmsSoItemList) {
				entity.setOrderNo(wmsSo.getOrderNo());
				wmsSoItemService.save(entity);
			}
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateMain(WmsSo wmsSo,List<WmsSoItem> wmsSoItemList) {
		this.updateById(wmsSo);
		
		//1.先删除子表数据
		wmsSoItemService.deleteByMainId(wmsSo.getOrderNo());
		
		//2.子表数据重新插入
		if(CollectionUtil.isNotEmpty(wmsSoItemList)) {
			for(WmsSoItem entity:wmsSoItemList) {
				entity.setOrderNo(wmsSo.getOrderNo());
				wmsSoItemService.save(entity);
			}
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String id) {
		wmsSoItemService.deleteByMainId(id);
		this.removeById(id);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			wmsSoItemService.deleteByMainId(id.toString());
			this.removeById(id);
		}
	}
	
}
