package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.jeecg.modules.wms.entity.WmsSoItem;
import org.jeecg.modules.wms.mapper.WmsSoItemMapper;
import org.jeecg.modules.wms.service.IWmsSoItemService;
import org.springframework.stereotype.Service;
import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: 出库单子项
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsSoItemServiceImpl extends ServiceImpl<WmsSoItemMapper, WmsSoItem> implements IWmsSoItemService {
	@Override
	public List<WmsSoItem> selectByMainId(String mainId) {
		return this.list(Wrappers.<WmsSoItem>lambdaQuery().eq(WmsSoItem::getOrderNo, mainId));
	}

	@Override
	public boolean deleteByMainId(String mainId) {
		return this.remove(Wrappers.<WmsSoItem>lambdaQuery().eq(WmsSoItem::getOrderNo, mainId));
	}
}
