package org.jeecg.modules.wms.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.wms.entity.WmsRo;
import org.jeecg.modules.wms.entity.WmsRoItem;
import org.jeecg.modules.wms.mapper.WmsRoItemMapper;
import org.jeecg.modules.wms.mapper.WmsRoMapper;
import org.jeecg.modules.wms.service.IWmsRoItemService;
import org.jeecg.modules.wms.service.IWmsRoService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 入库单
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsRoServiceImpl extends ServiceImpl<WmsRoMapper, WmsRo> implements IWmsRoService {
	@Autowired
	private IWmsRoItemService wmsRoItemService;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void saveMain(WmsRo wmsRo, List<WmsRoItem> wmsRoItemList) {
		this.save(wmsRo);
		if(CollectionUtil.isNotEmpty(wmsRoItemList)) {
			for(WmsRoItem entity:wmsRoItemList) {
				entity.setOrderNo(wmsRo.getOrderNo());
				wmsRoItemService.save(entity);
			}
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateMain(WmsRo wmsRo,List<WmsRoItem> wmsRoItemList) {
		this.updateById(wmsRo);
		
		//1.先删除子表数据
		wmsRoItemService.deleteByMainId(wmsRo.getOrderNo());
		
		//2.子表数据重新插入
		if(CollectionUtil.isNotEmpty(wmsRoItemList)) {
			for(WmsRoItem entity:wmsRoItemList) {
				entity.setOrderNo(wmsRo.getOrderNo());
				wmsRoItemService.save(entity);
			}
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String id) {
		wmsRoItemService.deleteByMainId(id);
		this.removeById(id);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			wmsRoItemService.deleteByMainId(id.toString());
			this.removeById(id);
		}
	}
	
}
