package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.jeecg.modules.wms.entity.WmsRoItem;
import org.jeecg.modules.wms.mapper.WmsRoItemMapper;
import org.jeecg.modules.wms.service.IWmsRoItemService;
import org.springframework.stereotype.Service;
import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: 入库单子项
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsRoItemServiceImpl extends ServiceImpl<WmsRoItemMapper, WmsRoItem> implements IWmsRoItemService {
	@Override
	public List<WmsRoItem> selectByMainId(String mainId) {
		return this.list(Wrappers.<WmsRoItem>lambdaQuery().eq(WmsRoItem::getOrderNo, mainId));
	}

	@Override
	public boolean deleteByMainId(String mainId) {
		return this.remove(Wrappers.<WmsRoItem>lambdaQuery().eq(WmsRoItem::getOrderNo, mainId));
	}
}
