package org.jeecg.modules.wms.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.jeecg.modules.wms.entity.WmsLoc;
import org.jeecg.modules.wms.entity.WmsStation;
import org.jeecg.modules.wms.mapper.WmsStationMapper;
import org.jeecg.modules.wms.mapper.WmsLocMapper;
import org.jeecg.modules.wms.service.IWmsLocService;
import org.jeecg.modules.wms.service.IWmsStationService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.sql.Wrapper;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 库位管理
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsLocServiceImpl extends ServiceImpl<WmsLocMapper, WmsLoc> implements IWmsLocService {
	@Autowired
	private IWmsStationService wmsStationService;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void saveMain(WmsLoc wmsLoc, List<WmsStation> wmsStationList) {
		this.save(wmsLoc);
		if(CollectionUtil.isNotEmpty(wmsStationList)) {
			for(WmsStation entity:wmsStationList) {
				entity.setLocCode(wmsLoc.getCode());
				wmsStationService.save(entity);
			}
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateMain(WmsLoc wmsLoc,List<WmsStation> wmsStationList) {
		this.updateById(wmsLoc);
		
		//1.先删除子表数据
		wmsStationService.deleteByMainCode(wmsLoc.getCode());
		
		//2.子表数据重新插入
		if(CollectionUtil.isNotEmpty(wmsStationList)) {
			for(WmsStation entity:wmsStationList) {
				entity.setLocCode(wmsLoc.getCode());
				wmsStationService.save(entity);
			}
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String code) {
		wmsStationService.deleteByMainCode(code);
		this.remove(Wrappers.<WmsLoc>lambdaQuery().eq(WmsLoc::getCode, code));

	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> codeList) {
		for(Serializable code:codeList) {
			wmsStationService.deleteByMainCode(code.toString());
			this.remove(Wrappers.<WmsLoc>lambdaQuery().eq(WmsLoc::getCode, code));
		}
	}
	
}
