package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.wms.entity.WmsContainer;
import org.jeecg.modules.wms.entity.WmsContainerGoods;
import org.jeecg.modules.wms.mapper.WmsContainerGoodsMapper;
import org.jeecg.modules.wms.mapper.WmsContainerMapper;
import org.jeecg.modules.wms.service.IWmsContainerGoodsService;
import org.jeecg.modules.wms.service.IWmsContainerService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;

/**
 * @Description: 容器
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsContainerServiceImpl extends ServiceImpl<WmsContainerMapper, WmsContainer> implements IWmsContainerService {
	@Autowired
	private IWmsContainerGoodsService wmsContainerGoodsService;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String id) {
		wmsContainerGoodsService.deleteByMainId(id);
		removeById(id);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			wmsContainerGoodsService.deleteByMainId(id.toString());
			removeById(id);
		}
	}
	
}
