package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.jeecg.modules.wms.entity.WmsContainerGoods;
import org.jeecg.modules.wms.mapper.WmsContainerGoodsMapper;
import org.jeecg.modules.wms.service.IWmsContainerGoodsService;
import org.springframework.stereotype.Service;
import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: 容器货品
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsContainerGoodsServiceImpl extends ServiceImpl<WmsContainerGoodsMapper, WmsContainerGoods> implements IWmsContainerGoodsService {
	@Override
	public List<WmsContainerGoods> selectByMainId(String mainId) {
		return this.list(Wrappers.<WmsContainerGoods>lambdaQuery().eq(WmsContainerGoods::getContainerCode, mainId));
	}

	@Override
	public boolean deleteByMainId(String mainId) {
		return this.remove(Wrappers.<WmsContainerGoods>lambdaQuery().eq(WmsContainerGoods::getContainerCode, mainId));
	}
}
