package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import org.jeecg.modules.pad.api.WmsCheckApi;
import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CheckCreateReq;
import org.jeecg.modules.pad.api.bean.req.CheckUpdateReq;
import org.jeecg.modules.wms.entity.WmsCheckBill;
import org.jeecg.modules.wms.mapper.WmsCheckBillMapper;
import org.jeecg.modules.wms.service.IWmsCheckBillDetailService;
import org.jeecg.modules.wms.service.IWmsCheckBillService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.Collection;

/**
 * @Description: 盘点单
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsCheckBillServiceImpl extends ServiceImpl<WmsCheckBillMapper, WmsCheckBill> implements IWmsCheckBillService {

	@Autowired
	private IWmsCheckBillDetailService wmsCheckBillEntryService;
	@Autowired
	private WmsCheckApi wmsCheckApi;
	
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delMain(String id) {
		wmsCheckBillEntryService.deleteByMainId(id);
		removeById(id);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void delBatchMain(Collection<? extends Serializable> idList) {
		for(Serializable id:idList) {
			wmsCheckBillEntryService.deleteByMainId(id.toString());
			removeById(id);
		}
	}

	@Override
	public WmsRes<?> create(CheckCreateReq req) {
		return wmsCheckApi.create(req);
	}

	@Override
	public WmsRes<?> pullDown(String orderNo) {
		return wmsCheckApi.pullDown(orderNo);
	}

	@Override
	public WmsRes<?> updateOrder(CheckUpdateReq req) {
		return wmsCheckApi.update(req);
	}

	@Override
	public WmsRes<?> cancel(String orderNo) {
		return wmsCheckApi.cancel(orderNo);
	}

	@Override
	public WmsRes<?> syncInventory(String orderNo) {
		return wmsCheckApi.syncInventory(orderNo);
	}

}
