package org.jeecg.modules.wms.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.jeecg.modules.wms.entity.WmsCheckBillDetail;
import org.jeecg.modules.wms.mapper.WmsCheckBillDetailMapper;
import org.jeecg.modules.wms.service.IWmsCheckBillDetailService;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.List;

/**
 * @Description: 盘点单详情表
 * @Author: jeecg-boot
 * @Date:   2024-09-02
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class WmsCheckBillDetailServiceImpl extends ServiceImpl<WmsCheckBillDetailMapper, WmsCheckBillDetail> implements IWmsCheckBillDetailService {
@Override
	public List<WmsCheckBillDetail> selectByMainId(String mainId) {
		return this.list(Wrappers.<WmsCheckBillDetail>lambdaQuery().eq(WmsCheckBillDetail::getOrderId, mainId));
	}

	@Override
	public boolean deleteByMainId(String mainId) {
		return this.remove(Wrappers.<WmsCheckBillDetail>lambdaQuery().eq(WmsCheckBillDetail::getOrderId, mainId));
	}
}
