package org.jeecg.modules.wms.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.jeecg.modules.wms.entity.ViewWmsStockLocSku;
import org.jeecg.modules.wms.mapper.ViewWmsStockLocSkuMapper;
import org.jeecg.modules.wms.service.IViewWmsStockLocSkuService;
import org.jeecg.modules.wms.vo.ViewStockStatisticsVo;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 库存信息
 * @Author: jeecg-boot
 * @Date:   2024-09-03
 * @Version: V1.0
 */
@DS("wms-db")
@Service
public class ViewWmsStockLocSkuServiceImpl extends ServiceImpl<ViewWmsStockLocSkuMapper, ViewWmsStockLocSku> implements IViewWmsStockLocSkuService {

    @Override
    public List<ViewStockStatisticsVo> statistics(QueryWrapper<ViewWmsStockLocSku> queryWrapper) {
        if (queryWrapper == null){
            queryWrapper = Wrappers.query();
        }
        queryWrapper.select("ware_code as wareCode",  "SUM(qty) AS totalQty")
                .groupBy("ware_code");
        List<Map<String, Object>> list = this.listMaps(queryWrapper);

        List<ViewStockStatisticsVo> result = new ArrayList<>();
        if (CollectionUtil.isEmpty(list)){
            return result;
        }

        list.forEach(map -> result.add(new ViewStockStatisticsVo(map.get("wareCode").toString(), (BigDecimal) map.get("totalQty"))));
        return result;
    }
}
