package org.jeecg.modules.wms.service;

import org.jeecg.modules.pad.api.bean.base.WmsRes;
import org.jeecg.modules.pad.api.bean.req.CheckCreateReq;
import org.jeecg.modules.pad.api.bean.req.CheckUpdateReq;
import org.jeecg.modules.wms.entity.WmsCheckBill;
import com.baomidou.mybatisplus.extension.service.IService;

import java.io.Serializable;
import java.util.Collection;

/**
 * @Description: 盘点单
 * @Author: jeecg-boot
 * @Date:   2024-07-30
 * @Version: V1.0
 */
public interface IWmsCheckBillService extends IService<WmsCheckBill> {
	public void delMain (String id);
	public void delBatchMain (Collection<? extends Serializable> idList);

	WmsRes<?> create(CheckCreateReq req);
	//Web盘点-下发盘点单
	WmsRes<?> pullDown(String orderNo);
	//Web盘点-修改盘点单
	WmsRes<?> updateOrder(CheckUpdateReq req);
	//Web盘点-取消盘点单
	WmsRes<?> cancel(String orderNo);
	//Web盘点-同步库存
	WmsRes<?> syncInventory(String orderNo);
}
