package org.jeecg.modules.wms.mapper;

import java.util.List;
import org.jeecg.modules.wms.entity.XhOutOrderDeliveryItem;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * @Description: 鑫宏配送单明细
 * @Author: jeecg-boot
 * @Date:   2024-11-29
 * @Version: V1.0
 */
public interface XhOutOrderDeliveryItemMapper extends BaseMapper<XhOutOrderDeliveryItem> {

	/**
	 * 通过主表id删除子表数据
	 *
	 * @param mainId 主表id
	 * @return boolean
	 */
	public boolean deleteByMainId(@Param("mainId") String mainId);

   /**
    * 通过主表id查询子表数据
    *
    * @param mainId 主表id
    * @return List<XhOutOrderDeliveryItem>
    */
	public List<XhOutOrderDeliveryItem> selectByMainId(@Param("mainId") String mainId);

}
