package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 任务推送失败记录
 * @Author: jeecg-boot
 * @Date:   2024-08-28
 * @Version: V1.0
 */
@Data
@TableName("xh_task_push_error")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="xh_task_push_error对象", description="任务推送失败记录")
public class XhTaskPushError implements Serializable {
    private static final long serialVersionUID = 1L;

	/**id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Integer id;
	/**任务号*/
	@Excel(name = "任务号", width = 15)
    @ApiModelProperty(value = "任务号")
    private String taskId;
	/**起始库位*/
	@Excel(name = "起始库位", width = 15)
    @ApiModelProperty(value = "起始库位")
    private String fromLoc;
	/**结束库位*/
	@Excel(name = "结束库位", width = 15)
    @ApiModelProperty(value = "结束库位")
    private String toLoc;
	/**托盘号*/
	@Excel(name = "托盘号", width = 15)
    @ApiModelProperty(value = "托盘号")
    private String tray;
	/**料箱号*/
	@Excel(name = "料箱号", width = 15)
    @ApiModelProperty(value = "料箱号")
    private String box;
	/**执行状态*/
	@Excel(name = "执行状态", width = 15)
    @ApiModelProperty(value = "执行状态")
    private String status;
	/**错误信息*/
	@Excel(name = "错误信息", width = 15)
    @ApiModelProperty(value = "错误信息")
    private String errorMsg;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
