package org.jeecg.modules.wms.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableLogic;
import org.jeecgframework.poi.excel.annotation.Excel;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description: 鑫泓出库需求单
 * @Author: jeecg-boot
 * @Date:   2024-11-10
 * @Version: V1.0
 */
@Data
@TableName("xh_out_order_requirement")
@ApiModel(value="xh_out_order_requirement对象", description="鑫泓出库需求单")
public class XhOutOrderRequirement implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private Integer id;
	/**货主编码*/
    @Excel(name = "货主编码", width = 15)
    @ApiModelProperty(value = "货主编码")
    private String ownerCode;
	/**客户订单号*/
    @Excel(name = "客户订单号", width = 15)
    @ApiModelProperty(value = "客户订单号")
    private String orderNo;
	/**出入库类型*/
    @Excel(name = "出入库类型", width = 15)
    @ApiModelProperty(value = "出入库类型")
    private String type;
	/**单据类型 product:生产出库 sales:销售出库*/
    @Excel(name = "单据类型 product:生产出库 sales:销售出库", width = 15)
    @ApiModelProperty(value = "单据类型 product:生产出库 sales:销售出库")
    private String receiptType;
	/**申请部门*/
    @Excel(name = "申请部门", width = 15)
    @ApiModelProperty(value = "申请部门")
    private String requiredDepartment;
	/**批次号，目前未使用*/
    @Excel(name = "批次号，目前未使用", width = 15)
    @ApiModelProperty(value = "批次号，目前未使用")
    private String batchNo;
	/**优先级*/
    @Excel(name = "优先级", width = 15)
    @ApiModelProperty(value = "优先级")
    private Integer priority;
	/**计划出库时间*/
    @Excel(name = "计划出库时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "计划出库时间")
    private Date planOutTime;
	/**是否强制出库 0:否 1:是*/
    @Excel(name = "是否强制出库 0:否 1:是", width = 15)
    @ApiModelProperty(value = "是否强制出库 0:否 1:是")
    private Integer isForcedOut;
	/**状态 INIT:初始化 FINISHED:已处理 CANCELLED:已放弃*/
    @Excel(name = "状态 INIT:初始化 FINISHED:已处理 CANCELLED:已放弃", width = 15)
    @ApiModelProperty(value = "状态 INIT:初始化 FINISHED:已处理 CANCELLED:已放弃")
    private String status;
	/**创建账号*/
    @ApiModelProperty(value = "创建账号")
    private String createBy;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改账号*/
    @ApiModelProperty(value = "修改账号")
    private String updateBy;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
}
